/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.item;

import fi.dy.masa.worldutils.item.base.IKeyBound;
import fi.dy.masa.worldutils.item.base.ItemWorldUtils;
import fi.dy.masa.worldutils.network.MessageChunkChanges;
import fi.dy.masa.worldutils.network.PacketHandler;
import fi.dy.masa.worldutils.reference.HotKeys;
import fi.dy.masa.worldutils.util.ChunkUtils;
import fi.dy.masa.worldutils.util.EntityUtils;
import fi.dy.masa.worldutils.util.NBTUtils;
import fi.dy.masa.worldutils.util.PositionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemChunkWand
extends ItemWorldUtils
implements IKeyBound {
    public static final String WRAPPER_TAG_NAME = "ChunkWand";
    public static final String TAG_NAME_MODE = "Mode";
    public static final String TAG_NAME_CONFIGS = "Configs";
    public static final String TAG_NAME_CONFIG_PRE = "Mode_";
    public static final String TAG_NAME_SELECTION = "Sel";
    protected Map<UUID, Long> lastLeftClick = new HashMap<UUID, Long>();

    public ItemChunkWand(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            this.setPosition(player.func_184586_b(hand), PositionUtils.getLookedAtChunk(world, player, 256), Corner.END);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            this.setPosition(player.func_184586_b(hand), PositionUtils.getChunkPosFromBlockPos(pos), Corner.END);
        }
        return EnumActionResult.SUCCESS;
    }

    public void onItemLeftClick(ItemStack stack, World world, EntityPlayer player) {
        this.setPosition(stack, PositionUtils.getLookedAtChunk(world, player, 256), Corner.START);
    }

    public void onLeftClickBlock(EntityPlayer player, World world, ItemStack stack, BlockPos pos, int dimension, EnumFacing side) {
        if (world.field_72995_K) {
            return;
        }
        Long last = this.lastLeftClick.get(player.func_110124_au());
        if (last == null || world.func_82737_E() - last >= 4L) {
            this.setPosition(stack, PositionUtils.getChunkPosFromBlockPos(pos), Corner.START);
        }
        this.lastLeftClick.put(player.func_110124_au(), world.func_82737_E());
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return true;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !oldStack.equals(newStack);
    }

    public ChunkPos getPosition(ItemStack stack, Corner corner) {
        return this.getPosition(stack, Mode.getMode(stack), corner);
    }

    public ChunkPos getPosition(ItemStack stack, Mode mode, Corner corner) {
        String tagName;
        NBTTagCompound tag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, true);
        String string = tagName = corner == Corner.START ? "Pos1" : "Pos2";
        if (tag.func_150297_b(tagName, 10)) {
            tag = tag.func_74775_l(tagName);
            return new ChunkPos(tag.func_74762_e("chunkX"), tag.func_74762_e("chunkZ"));
        }
        return null;
    }

    private void setPosition(ItemStack stack, ChunkPos pos, Corner corner) {
        this.setPosition(stack, Mode.getMode(stack), pos, corner);
    }

    private void setPosition(ItemStack stack, Mode mode, ChunkPos pos, Corner corner) {
        String tagName;
        NBTTagCompound tag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, true);
        String string = tagName = corner == Corner.START ? "Pos1" : "Pos2";
        if (pos == null || pos.equals((Object)this.getPosition(stack, mode, corner))) {
            tag.func_82580_o(tagName);
        } else {
            NBTTagCompound posTag = new NBTTagCompound();
            posTag.func_74768_a("chunkX", pos.field_77276_a);
            posTag.func_74768_a("chunkZ", pos.field_77275_b);
            tag.func_74782_a(tagName, (NBTBase)posTag);
        }
    }

    private void movePosition(ItemStack stack, EnumFacing direction, boolean reverse, Corner corner) {
        ChunkPos pos = this.getPosition(stack, corner);
        if (pos != null) {
            int amount = reverse ? 1 : -1;
            pos = new ChunkPos(pos.field_77276_a + direction.func_82601_c() * amount, pos.field_77275_b + direction.func_82599_e() * amount);
            this.setPosition(stack, pos, corner);
        }
    }

    public Collection<ChunkPos> getCurrentAndStoredSelections(ItemStack stack) {
        Collection<ChunkPos> chunks = this.getCurrentSelection(stack);
        chunks.addAll(this.getStoredSelection(stack));
        return chunks;
    }

    public Collection<ChunkPos> getCurrentSelection(ItemStack stack) {
        ArrayList<ChunkPos> list = new ArrayList<ChunkPos>();
        ChunkPos start = this.getPosition(stack, Corner.START);
        ChunkPos end = this.getPosition(stack, Corner.END);
        if (start != null && end != null) {
            int minX = Math.min(start.field_77276_a, end.field_77276_a);
            int minZ = Math.min(start.field_77275_b, end.field_77275_b);
            int maxX = Math.max(start.field_77276_a, end.field_77276_a);
            int maxZ = Math.max(start.field_77275_b, end.field_77275_b);
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    list.add(new ChunkPos(x, z));
                }
            }
        } else if (start != null) {
            list.add(start);
        } else if (end != null) {
            list.add(end);
        }
        return list;
    }

    public Collection<ChunkPos> getStoredSelection(ItemStack stack) {
        HashSet<ChunkPos> stored = new HashSet<ChunkPos>();
        NBTTagCompound tag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, true);
        NBTTagList list = tag.func_150295_c("Chunks", 4);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTBase nbt = list.func_179238_g(i);
            if (nbt.func_74732_a() != 4) continue;
            long val = ((NBTTagLong)nbt).func_150291_c();
            stored.add(new ChunkPos((int)(val & 0xFFFFFFFFFFFFFFFFL), (int)(val >>> 32) & 0xFFFFFFFF));
        }
        return stored;
    }

    private void setStoredChunks(ItemStack stack, Collection<ChunkPos> chunks) {
        NBTTagCompound tag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, true);
        NBTTagList list = new NBTTagList();
        for (ChunkPos pos : chunks) {
            list.func_74742_a((NBTBase)new NBTTagLong(ChunkPos.func_77272_a((int)pos.field_77276_a, (int)pos.field_77275_b)));
        }
        tag.func_74782_a("Chunks", (NBTBase)list);
    }

    private void addCurrentSelectionToStoredSet(ItemStack stack) {
        Collection<ChunkPos> current = this.getCurrentSelection(stack);
        Collection<ChunkPos> stored = this.getStoredSelection(stack);
        stored.addAll(current);
        this.setStoredChunks(stack, stored);
    }

    private void removeCurrentSelectionFromStoredSet(ItemStack stack) {
        Collection<ChunkPos> current = this.getCurrentSelection(stack);
        Collection<ChunkPos> stored = this.getStoredSelection(stack);
        stored.removeAll(current);
        this.setStoredChunks(stack, stored);
    }

    public int getNumTargets(ItemStack stack) {
        return NBTUtils.getByte(stack, WRAPPER_TAG_NAME, "NumTargets");
    }

    private void setNumTargets(ItemStack stack, World world) {
        int num = ChunkUtils.getNumberOfAlternateWorlds();
        NBTUtils.setByte(stack, WRAPPER_TAG_NAME, "NumTargets", (byte)num);
    }

    public int getTargetSelection(ItemStack stack) {
        return NBTUtils.getByte(stack, WRAPPER_TAG_NAME, TAG_NAME_SELECTION);
    }

    private void changeTargetSelection(ItemStack stack, World world, boolean reverse) {
        NBTTagCompound tag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, true);
        int max = this.getNumTargets(stack);
        NBTUtils.cycleByteValue(tag, TAG_NAME_SELECTION, 0, max - 1, reverse);
        tag.func_74778_a("WorldName", ChunkUtils.getWorldName(tag.func_74771_c(TAG_NAME_SELECTION)));
    }

    public String getWorldName(ItemStack stack) {
        return NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, true).func_74779_i("WorldName");
    }

    public String getBiomeName(ItemStack stack) {
        return NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, true).func_74779_i("BiomeName");
    }

    public int getBiomeIndex(ItemStack stack) {
        return NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, true).func_74771_c("BiomeIndex");
    }

    private EnumActionResult useWand(ItemStack stack, World world, EntityPlayer player) {
        Mode mode = Mode.getMode(stack);
        if (mode == Mode.CHUNK_SWAP) {
            return this.useWandChunkSwap(stack, world, player);
        }
        if (mode == Mode.BIOME_IMPORT) {
            return this.useWandBiomeImport(stack, world, player);
        }
        if (mode == Mode.BIOME_SET) {
            return this.useWandBiomeSet(stack, world, player);
        }
        return EnumActionResult.PASS;
    }

    private EnumActionResult useWandChunkSwap(ItemStack stack, World world, EntityPlayer player) {
        Collection<ChunkPos> locations = this.getCurrentAndStoredSelections(stack);
        String worldName = this.getWorldName(stack);
        for (ChunkPos pos : locations) {
            ChunkUtils.instance().loadChunkFromAlternateWorld(world, pos, worldName, player.func_70005_c_());
        }
        PacketHandler.INSTANCE.sendTo((IMessage)new MessageChunkChanges(ChunkUtils.ChangeType.CHUNK_CHANGE, locations, worldName), (EntityPlayerMP)player);
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult useWandBiomeImport(ItemStack stack, World world, EntityPlayer player) {
        Collection<ChunkPos> locations = this.getCurrentAndStoredSelections(stack);
        String worldName = this.getWorldName(stack);
        for (ChunkPos pos : locations) {
            ChunkUtils.instance().loadBiomesFromAlternateWorld(world, pos, worldName, player.func_70005_c_());
        }
        PacketHandler.INSTANCE.sendTo((IMessage)new MessageChunkChanges(ChunkUtils.ChangeType.BIOME_IMPORT, locations, worldName), (EntityPlayerMP)player);
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult useWandBiomeSet(ItemStack stack, World world, EntityPlayer player) {
        Collection<ChunkPos> locations = this.getCurrentAndStoredSelections(stack);
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(this.getBiomeName(stack)));
        for (ChunkPos pos : locations) {
            ChunkUtils.instance().setBiome(world, pos, biome, player.func_70005_c_());
        }
        PacketHandler.INSTANCE.sendTo((IMessage)new MessageChunkChanges(ChunkUtils.ChangeType.BIOME_SET, locations, ""), (EntityPlayerMP)player);
        return EnumActionResult.SUCCESS;
    }

    private void changeSelectedBiome(ItemStack stack, boolean reverse) {
        ResourceLocation selected = new ResourceLocation(this.getBiomeName(stack));
        ArrayList<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
        ArrayList<Integer> biomeIds = new ArrayList<Integer>();
        for (Map.Entry entry : ForgeRegistries.BIOMES.getEntries()) {
            biomeIds.add(Biome.func_185362_a((Biome)((Biome)ForgeRegistries.BIOMES.getValue((ResourceLocation)entry.getKey()))));
        }
        Collections.sort(biomeIds);
        int index = -1;
        int i = 0;
        for (Integer id : biomeIds) {
            ResourceLocation rl = ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)Biome.func_150568_d((int)id));
            biomes.add(rl);
            if (rl.equals((Object)selected)) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            index = 0;
        } else if ((index += reverse ? -1 : 1) < 0) {
            index = biomes.size() - 1;
        } else if (index >= biomes.size()) {
            index = 0;
        }
        NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, true).func_74778_a("BiomeName", ((ResourceLocation)biomes.get(index)).toString());
        NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, true).func_74774_a("BiomeId", (byte)((Integer)biomeIds.get(index)).intValue());
        NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, true).func_74774_a("BiomeIndex", (byte)index);
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (key == 0x10000000) {
            this.onItemLeftClick(stack, player.func_130014_f_(), player);
            return;
        }
        Mode mode = Mode.getMode(stack);
        if (HotKeys.EnumKey.SCROLL.matches(key, 327680)) {
            this.movePosition(stack, EntityUtils.getHorizontalLookingDirection((Entity)player), HotKeys.EnumKey.keypressActionIsReversed(key), Corner.START);
        } else if (HotKeys.EnumKey.SCROLL.matches(key, 65536)) {
            this.movePosition(stack, EntityUtils.getHorizontalLookingDirection((Entity)player), HotKeys.EnumKey.keypressActionIsReversed(key), Corner.END);
        } else if (HotKeys.EnumKey.SCROLL.matches(key, 262144)) {
            if (mode == Mode.BIOME_SET) {
                this.changeSelectedBiome(stack, HotKeys.EnumKey.keypressActionIsReversed(key));
            } else {
                this.setNumTargets(stack, player.func_130014_f_());
                this.changeTargetSelection(stack, player.func_130014_f_(), HotKeys.EnumKey.keypressActionIsReversed(key));
            }
        } else if (HotKeys.EnumKey.SCROLL.matches(key, 131072)) {
            Mode.cycleMode(stack, HotKeys.EnumKey.keypressActionIsReversed(key) || HotKeys.EnumKey.keypressContainsShift(key), player);
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 393216)) {
            this.setStoredChunks(stack, new ArrayList<ChunkPos>());
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 65536)) {
            this.removeCurrentSelectionFromStoredSet(stack);
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 262144)) {
            this.addCurrentSelectionToStoredSet(stack);
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 458752)) {
            ChunkUtils.instance().clearChangedChunksForUser(player.func_130014_f_(), player.func_70005_c_());
            player.func_145747_a((ITextComponent)new TextComponentTranslation("worldutils.chat.message.chunkwand.clearedchangedchunks", new Object[0]));
        } else if (HotKeys.EnumKey.TOGGLE.matches(key, 0) && this.useWand(stack, player.func_130014_f_(), player) == EnumActionResult.SUCCESS) {
            player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.MASTER, 0.4f, 0.7f);
        }
    }

    public static enum Corner {
        START,
        END;

    }

    public static enum Mode {
        CHUNK_SWAP("chunk_swap", "worldutils.tooltip.item.chunkwand.chunkswap", true),
        BIOME_IMPORT("biome_import", "worldutils.tooltip.item.chunkwand.biomeimport", true),
        BIOME_SET("biome_set", "worldutils.tooltip.item.chunkwand.biomeset", true);

        private final String name;
        private final String unlocName;
        private final boolean hasUseDelay;

        private Mode(String name, String unlocName, boolean useDelay) {
            this.name = name;
            this.unlocName = unlocName;
            this.hasUseDelay = useDelay;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return I18n.func_135052_a((String)this.unlocName, (Object[])new Object[0]);
        }

        public boolean hasUseDelay() {
            return this.hasUseDelay;
        }

        public static Mode getMode(ItemStack stack) {
            return Mode.values()[Mode.getModeOrdinal(stack)];
        }

        public static void cycleMode(ItemStack stack, boolean reverse, EntityPlayer player) {
            NBTUtils.cycleByteValue(stack, ItemChunkWand.WRAPPER_TAG_NAME, ItemChunkWand.TAG_NAME_MODE, Mode.values().length - 1, reverse);
        }

        public static int getModeOrdinal(ItemStack stack) {
            byte id = NBTUtils.getByte(stack, ItemChunkWand.WRAPPER_TAG_NAME, ItemChunkWand.TAG_NAME_MODE);
            return id >= 0 && id < Mode.values().length ? (int)id : 0;
        }

        public static int getModeCount(EntityPlayer player) {
            return Mode.values().length;
        }
    }
}

