/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.item.base;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.item.base.CreativeTab;
import fi.dy.masa.worldutils.reference.ReferenceNames;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemWorldUtils
extends Item {
    protected final String name;

    public ItemWorldUtils(String name) {
        this.name = name;
        this.func_77637_a(CreativeTab.WORLD_UTILS_TAB);
        this.func_77655_b(name);
        this.addItemOverrides();
    }

    public String getItemNameWorldUtils() {
        return this.name;
    }

    public Item func_77655_b(String name) {
        return super.func_77655_b(ReferenceNames.getPrefixedName(name));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !oldStack.equals(newStack);
    }

    public String getBaseItemDisplayName(ItemStack stack) {
        if (stack.func_82837_s()) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("display");
            return TextFormatting.ITALIC.toString() + tag.func_74779_i("Name") + TextFormatting.RESET.toString();
        }
        return super.func_77653_i(stack);
    }

    public void addInformationSelective(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag advanced, boolean verbose) {
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag advanced) {
        ArrayList<String> tmpList = new ArrayList<String>();
        boolean verbose = WorldUtils.proxy.isShiftKeyDown();
        if (stack.func_77978_p() == null) {
            this.addTooltips(stack, tmpList, verbose);
            if (!verbose && tmpList.size() > 2) {
                list.add(I18n.func_135052_a((String)"worldutils.tooltip.item.holdshiftfordescription", (Object[])new Object[0]));
            } else {
                list.addAll(tmpList);
            }
        }
        tmpList.clear();
        this.addInformationSelective(stack, world, tmpList, advanced, true);
        if (!verbose && tmpList.size() > 2) {
            tmpList.clear();
            this.addInformationSelective(stack, world, tmpList, advanced, false);
            if (tmpList.size() > 0) {
                list.add(tmpList.get(0));
            }
            list.add(I18n.func_135052_a((String)"worldutils.tooltip.item.holdshift", (Object[])new Object[0]));
        } else {
            list.addAll(tmpList);
        }
    }

    public static void addTooltips(String key, List<String> list, boolean verbose) {
        String translated = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        if (!translated.equals(key)) {
            if (translated.contains("|lf")) {
                String[] lines;
                for (String line : lines = translated.split(Pattern.quote("|lf"))) {
                    list.add(line);
                }
            } else {
                list.add(translated);
            }
        }
    }

    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemWorldUtils.addTooltips(this.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    public ResourceLocation[] getItemVariants() {
        return new ResourceLocation[]{ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this)};
    }

    public ModelResourceLocation getModelLocation(ItemStack stack) {
        return null;
    }

    protected void addItemOverrides() {
    }
}

