/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.network;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.compat.journeymap.ChunkChangeTracker;
import fi.dy.masa.worldutils.util.ChunkUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageChunkChanges
implements IMessage {
    private byte type;
    private int numChunks;
    private String worldName;
    private Collection<ChunkPos> chunks;
    private NBTTagCompound nbt;

    public MessageChunkChanges() {
    }

    public MessageChunkChanges(ChunkUtils.ChangeType type, Collection<ChunkPos> chunks, String worldName) {
        this.type = (byte)type.ordinal();
        this.numChunks = chunks.size();
        this.worldName = worldName;
        this.chunks = chunks;
    }

    public MessageChunkChanges(NBTTagCompound nbt) {
        this.type = (byte)-1;
        this.nbt = nbt;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readByte();
        if (this.type == -1) {
            this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
        } else {
            this.worldName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.numChunks = buf.readInt();
            this.chunks = new ArrayList<ChunkPos>();
            for (int i = 0; i < this.numChunks; ++i) {
                this.chunks.add(new ChunkPos(buf.readInt(), buf.readInt()));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.type);
        if (this.type == -1) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.worldName);
            buf.writeInt(this.numChunks);
            for (ChunkPos pos : this.chunks) {
                buf.writeInt(pos.field_77276_a);
                buf.writeInt(pos.field_77275_b);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<MessageChunkChanges, IMessage> {
        public IMessage onMessage(final MessageChunkChanges message, MessageContext ctx) {
            if (ctx.side != Side.CLIENT) {
                WorldUtils.logger.error("Wrong side in MessageChunkChanges: " + ctx.side);
                return null;
            }
            Minecraft mc = FMLClientHandler.instance().getClient();
            final EntityPlayer player = WorldUtils.proxy.getPlayerFromMessageContext(ctx);
            if (mc == null || player == null) {
                WorldUtils.logger.error("Minecraft or player was null in MessageSyncSlot");
                return null;
            }
            mc.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    this.processMessage(message, player);
                }
            });
            return null;
        }

        protected void processMessage(MessageChunkChanges message, EntityPlayer player) {
            if (message.type == -1) {
                ChunkChangeTracker.instance().readAllChangesFromNBT(message.nbt);
            } else {
                ChunkChangeTracker.instance().addIncrementalChanges(ChunkUtils.ChangeType.fromId(message.type), message.chunks, message.worldName);
            }
        }
    }
}

