/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.network;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.item.base.IKeyBound;
import fi.dy.masa.worldutils.util.EntityUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageKeyPressed
implements IMessage {
    private int keyPressed;

    public MessageKeyPressed() {
    }

    public MessageKeyPressed(int key) {
        this.keyPressed = key;
    }

    public void fromBytes(ByteBuf buf) {
        this.keyPressed = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.keyPressed);
    }

    public static class Handler
    implements IMessageHandler<MessageKeyPressed, IMessage> {
        public IMessage onMessage(final MessageKeyPressed message, MessageContext ctx) {
            if (ctx.side != Side.SERVER) {
                WorldUtils.logger.error("Wrong side in MessageKeyPressed: " + ctx.side);
                return null;
            }
            final EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
            if (sendingPlayer == null) {
                WorldUtils.logger.error("Sending player was null in MessageKeyPressed");
                return null;
            }
            WorldServer playerWorldServer = sendingPlayer.func_71121_q();
            if (playerWorldServer == null) {
                WorldUtils.logger.error("World was null in MessageKeyPressed");
                return null;
            }
            playerWorldServer.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    this.processMessage(message, (EntityPlayer)sendingPlayer);
                }
            });
            return null;
        }

        protected void processMessage(MessageKeyPressed message, EntityPlayer player) {
            ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, IKeyBound.class);
            if (!stack.func_190926_b()) {
                ((IKeyBound)stack.func_77973_b()).doKeyBindingAction(player, stack, message.keyPressed);
            }
        }
    }
}

