/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.proxy;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.config.Configs;
import fi.dy.masa.worldutils.event.InputEventHandler;
import fi.dy.masa.worldutils.event.PlayerEventHandler;
import fi.dy.masa.worldutils.event.RenderEventHandler;
import fi.dy.masa.worldutils.event.TickHandler;
import fi.dy.masa.worldutils.event.WorldEventHandler;
import fi.dy.masa.worldutils.item.base.ItemWorldUtils;
import fi.dy.masa.worldutils.proxy.IProxy;
import fi.dy.masa.worldutils.reference.Keybindings;
import fi.dy.masa.worldutils.registry.WorldUtilsItems;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
implements IProxy {
    @Override
    public EntityPlayer getPlayerFromMessageContext(MessageContext ctx) {
        switch (ctx.side) {
            case CLIENT: {
                return FMLClientHandler.instance().getClientPlayerEntity();
            }
            case SERVER: {
                return ctx.getServerHandler().field_147369_b;
            }
        }
        WorldUtils.logger.warn("Invalid side in getPlayerFromMessageContext(): " + ctx.side);
        return null;
    }

    @Override
    public void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new Configs());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WorldEventHandler());
        if (!Configs.disableChunkWand) {
            MinecraftForge.EVENT_BUS.register((Object)new InputEventHandler());
            MinecraftForge.EVENT_BUS.register((Object)new RenderEventHandler());
        }
    }

    @Override
    public void registerKeyBindings() {
        if (!Configs.disableChunkWand) {
            Keybindings.keyToggleMode = new KeyBinding("worldutils.key.togglemode", 19, "category.worldutils");
            ClientRegistry.registerKeyBinding((KeyBinding)Keybindings.keyToggleMode);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ClientProxy.registerItemModel(WorldUtilsItems.CHUNK_WAND, 0);
    }

    private static void registerItemModel(ItemWorldUtils item, int meta) {
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    @Override
    public boolean isShiftKeyDown() {
        return GuiScreen.func_146272_n();
    }

    @Override
    public boolean isControlKeyDown() {
        return GuiScreen.func_146271_m();
    }

    @Override
    public boolean isAltKeyDown() {
        return GuiScreen.func_175283_s();
    }
}

