/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.util;

import fi.dy.masa.worldutils.WorldUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class BlockData {
    private DataType type;
    private int id;
    private int meta;
    private int blockStateId;
    private int[] blockStateIds = new int[0];
    private String name = "";
    private List<Pair<String, String>> props = new ArrayList<Pair<String, String>>();

    public BlockData(int id) {
        this.type = DataType.ID;
        this.id = id;
        this.setNumericValues();
    }

    public BlockData(int id, int meta) {
        this.type = DataType.ID_META;
        this.id = id;
        this.meta = meta;
        this.setNumericValues();
    }

    public BlockData(String name) {
        this.type = DataType.NAME;
        this.name = name;
        this.setNumericValues();
    }

    public BlockData(String name, int meta) {
        this.type = DataType.NAME_META;
        this.name = name;
        this.meta = meta;
        this.setNumericValues();
    }

    public BlockData(String name, List<Pair<String, String>> props) {
        this.type = DataType.NAME_PROPS;
        this.name = name;
        this.props.addAll(props);
        this.setNumericValues();
    }

    public DataType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getMeta() {
        return this.meta;
    }

    public int getBlockStateId() {
        return this.blockStateId;
    }

    public int[] getBlockStateIds() {
        return this.blockStateIds;
    }

    public boolean ignoreMeta() {
        return this.type == DataType.ID || this.type == DataType.NAME;
    }

    public boolean isValid() {
        switch (this.type) {
            case ID: {
                return this.id >= 0 && this.id < 4096;
            }
            case ID_META: {
                return this.id >= 0 && this.id < 4096 && this.meta >= 0 && this.meta < 16;
            }
            case NAME: {
                return Block.field_149771_c.func_148741_d((Object)new ResourceLocation(this.name));
            }
            case NAME_META: {
                return Block.field_149771_c.func_148741_d((Object)new ResourceLocation(this.name)) && this.meta >= 0 && this.meta < 16;
            }
            case NAME_PROPS: {
                if (!Block.field_149771_c.func_148741_d((Object)new ResourceLocation(this.name))) {
                    return false;
                }
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(this.name));
                for (Pair<String, String> pair : this.props) {
                    IProperty prop = block.func_176194_O().func_185920_a((String)pair.getLeft());
                    if (prop != null && prop.func_185929_b((String)pair.getRight()).isPresent()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private void setNumericValues() {
        if (this.isValid()) {
            switch (this.type) {
                case NAME: {
                    this.id = Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(this.name))));
                    break;
                }
                case NAME_META: {
                    this.id = Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(this.name))));
                    break;
                }
                case NAME_PROPS: {
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(this.name));
                    IBlockState state = block.func_176223_P();
                    for (Pair<String, String> pair : this.props) {
                        IProperty prop = block.func_176194_O().func_185920_a((String)pair.getLeft());
                        if (prop == null) continue;
                        state = BlockData.setPropertyValueFromString(state, prop, (String)pair.getRight());
                    }
                    int stateId = Block.func_176210_f((IBlockState)state);
                    this.id = stateId & 0xFFF;
                    this.meta = stateId >> 12 & 0xF;
                    break;
                }
            }
            this.setBlockstateIds();
        }
    }

    private void setBlockstateIds() {
        if (this.isValid()) {
            this.blockStateId = this.meta << 12 | this.id;
            if (this.ignoreMeta()) {
                int[] ids = new int[16];
                for (int i = 0; i < 16; ++i) {
                    ids[i] = i << 12 | this.id;
                }
                this.blockStateIds = ids;
            } else {
                this.blockStateIds = new int[]{this.blockStateId};
            }
        }
    }

    public String toString() {
        if (this.type == DataType.ID) {
            return "BlockData:{ type=" + (Object)((Object)this.type) + ", id=" + this.id + " }";
        }
        if (this.type == DataType.ID_META) {
            return "BlockData:{ type=" + (Object)((Object)this.type) + ", id=" + this.id + ", meta=" + this.meta + " }";
        }
        if (this.type == DataType.NAME) {
            return "BlockData:{ type=" + (Object)((Object)this.type) + ", name=" + this.name + ", id=" + this.id + " }";
        }
        if (this.type == DataType.NAME_META) {
            return "BlockData:{ type=" + (Object)((Object)this.type) + ", name=" + this.name + ", meta=" + this.meta + ", id=" + this.id + " }";
        }
        if (this.type == DataType.NAME_PROPS) {
            StringBuilder propStr = new StringBuilder(128);
            for (Pair<String, String> pair : this.props) {
                propStr.append((String)pair.getLeft()).append("=").append((String)pair.getRight()).append(",");
            }
            if (propStr.length() > 0) {
                propStr.deleteCharAt(propStr.length() - 1);
            }
            return "BlockData:{ type=" + (Object)((Object)this.type) + ", name=" + this.name + ", props=[" + propStr.toString() + "], id=" + this.id + ", meta=" + this.meta + " }";
        }
        return "BlockData:{type=INVALID}";
    }

    public static BlockData parseBlockTypeFromString(String str) {
        try {
            Pattern patternId = Pattern.compile("(?<id>[0-9]+)");
            Pattern patternIdMeta = Pattern.compile("(?<id>[0-9]+)[@:]{1}(?<meta>[0-9]+)");
            Pattern patternName = Pattern.compile("(?<name>([a-z0-9_]+:)?[a-z0-9\\._ ]+)");
            Pattern patternNameMeta = Pattern.compile("(?<name>([a-z0-9_]+:)?[a-z0-9\\._ ]+)[@:]{1}(?<meta>[0-9]+)");
            Pattern patternNameProps = Pattern.compile("(?<name>([a-z0-9_]+:)?[a-z0-9\\._ ]+)\\[(?<props>[a-z0-9_]+=[a-z0-9_]+(,[a-z0-9_]+=[a-z0-9_]+)*)\\]");
            Matcher matcherId = patternId.matcher(str);
            if (matcherId.matches()) {
                return new BlockData(Integer.parseInt(matcherId.group("id")));
            }
            Matcher matcherIdMeta = patternIdMeta.matcher(str);
            if (matcherIdMeta.matches()) {
                return new BlockData(Integer.parseInt(matcherIdMeta.group("id")), Integer.parseInt(matcherIdMeta.group("meta")));
            }
            Matcher matcherName = patternName.matcher(str);
            if (matcherName.matches()) {
                return new BlockData(matcherName.group("name"));
            }
            Matcher matcherNameMeta = patternNameMeta.matcher(str);
            if (matcherNameMeta.matches()) {
                return new BlockData(matcherNameMeta.group("name"), Integer.parseInt(matcherNameMeta.group("meta")));
            }
            Matcher matcherNameProps = patternNameProps.matcher(str);
            if (matcherNameProps.matches()) {
                String name = matcherNameProps.group("name");
                String propStr = matcherNameProps.group("props");
                String[] propParts = propStr.split(",");
                Pattern patternProp = Pattern.compile("(?<prop>[a-zA-Z0-9\\._-]+)=(?<value>[a-zA-Z0-9\\._-]+)");
                ArrayList<Pair<String, String>> props = new ArrayList<Pair<String, String>>();
                for (int i = 0; i < propParts.length; ++i) {
                    Matcher matcherProp = patternProp.matcher(propParts[i]);
                    if (matcherProp.matches()) {
                        props.add((Pair<String, String>)Pair.of((Object)matcherProp.group("prop"), (Object)matcherProp.group("value")));
                        continue;
                    }
                    WorldUtils.logger.warn("Invalid block property '{}'", (Object)propParts[i]);
                }
                Collections.sort(props);
                return new BlockData(name, props);
            }
        }
        catch (PatternSyntaxException e) {
            WorldUtils.logger.warn("Invalid regex pattern in parseBlockTypeFromString()", (Throwable)e);
        }
        catch (Exception e) {
            WorldUtils.logger.warn("Failed to parse block type in parseBlockTypeFromString()", (Throwable)e);
        }
        return null;
    }

    public static <T extends Comparable<T>> IBlockState setPropertyValueFromString(IBlockState state, IProperty<T> prop, String valueStr) {
        return state.func_177226_a(prop, (Comparable)prop.func_185929_b(valueStr).get());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + this.meta;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockData other = (BlockData)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.meta != other.meta) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum DataType {
        ID,
        ID_META,
        NAME,
        NAME_META,
        NAME_PROPS;

    }
}

