/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.util;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.data.DataDump;
import fi.dy.masa.worldutils.util.NBTFormatter;
import java.io.File;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockInfo {
    private static final Field field_REGISTRY = ReflectionHelper.findField(TileEntity.class, (String[])new String[]{"field_190562_f", "REGISTRY"});

    private static List<String> getBasicBlockInfo(int blockId, int meta, boolean hasTileNBT) {
        ArrayList<String> lines = new ArrayList<String>();
        IBlockState state = Block.func_176220_d((int)(meta << 12 | blockId));
        Block block = state.func_177230_c();
        ItemStack stack = new ItemStack(block, 1, block.func_180651_a(state));
        String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString();
        String dname = !stack.func_190926_b() ? stack.func_82833_r() : name;
        boolean shouldHaveTE = block.hasTileEntity(state);
        if (hasTileNBT == shouldHaveTE) {
            if (hasTileNBT) {
                lines.add(String.format("%s (%s - %d:%d) has a TileEntity", dname, name, blockId, meta));
            } else {
                lines.add(String.format("%s (%s - %d:%d) no TileEntity", dname, name, blockId, meta));
            }
        } else if (hasTileNBT) {
            lines.add(String.format("%s (%s - %d:%d) !! is not supposed to have a TileEntity, but there is TileEntity NBT in the chunk data !!", dname, name, blockId, meta));
        } else {
            lines.add(String.format("%s (%s - %d:%d) !! is supposed to have a TileEntity, but there isn't TileEntity NBT in the chunk !!", dname, name, blockId, meta));
        }
        return lines;
    }

    private static List<String> getFullBlockInfo(int blockId, int meta, NBTTagCompound tileNBT, int modified) {
        List<String> lines = BlockInfo.getBasicBlockInfo(blockId, meta, tileNBT != null);
        IBlockState state = Block.func_176220_d((int)(meta << 12 | blockId));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        String str = sdf.format(new Date((long)modified * 1000L));
        lines.add("Chunk last modified on " + str);
        lines.add("Block class: " + state.func_177230_c().getClass().getName());
        if (state.func_177228_b().size() > 0) {
            lines.add("IBlockState properties, excluding getActualState():");
            for (Map.Entry entry : state.func_177228_b().entrySet()) {
                lines.add(((IProperty)entry.getKey()).toString() + ": " + ((Comparable)entry.getValue()).toString());
            }
        } else {
            lines.add("IBlockState properties: <none>");
        }
        if (tileNBT != null) {
            TileEntity te = BlockInfo.createTileEntity(tileNBT.func_74779_i("id"));
            if (te != null) {
                lines.add("TileEntity class: " + te.getClass().getName());
            }
            lines.add("");
            lines.add("TileEntity NBT (from Chunk NBT data on disk):");
            NBTFormatter.getPrettyFormattedNBT(lines, tileNBT);
        }
        return lines;
    }

    @Nullable
    private static TileEntity createTileEntity(String id) {
        try {
            RegistryNamespaced registry = (RegistryNamespaced)field_REGISTRY.get(null);
            Class clazz = (Class)registry.func_82594_a((Object)new ResourceLocation(id));
            if (clazz != null) {
                return (TileEntity)clazz.newInstance();
            }
        }
        catch (Throwable t) {
            WorldUtils.logger.warn("Failed to create block entity '{}'", (Object)id, (Object)t);
        }
        return null;
    }

    private static void printBasicBlockInfoToChat(int blockId, int meta, boolean hasTileNBT, ICommandSender sender) {
        for (String line : BlockInfo.getBasicBlockInfo(blockId, meta, hasTileNBT)) {
            sender.func_145747_a((ITextComponent)new TextComponentString(line));
        }
    }

    private static void printBlockInfoToConsole(int blockId, int meta, NBTTagCompound tileNBT, int modified) {
        List<String> lines = BlockInfo.getFullBlockInfo(blockId, meta, tileNBT, modified);
        for (String line : lines) {
            WorldUtils.logger.info(line);
        }
    }

    private static void dumpBlockInfoToFile(int blockId, int meta, NBTTagCompound tileNBT, ICommandSender sender, int modified) {
        File f = DataDump.dumpDataToFile("block_and_tileentity_data", BlockInfo.getFullBlockInfo(blockId, meta, tileNBT, modified));
        sender.func_145747_a((ITextComponent)new TextComponentString("Output written to file " + f.getName()));
    }

    public static void outputBlockInfo(int blockId, int meta, NBTTagCompound tileNBT, boolean dumpToFile, ICommandSender sender, int modified) {
        BlockInfo.printBasicBlockInfoToChat(blockId, meta, tileNBT != null, sender);
        if (dumpToFile) {
            BlockInfo.dumpBlockInfoToFile(blockId, meta, tileNBT, sender, modified);
        } else {
            BlockInfo.printBlockInfoToConsole(blockId, meta, tileNBT, modified);
        }
    }
}

