/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.util;

import com.google.common.base.Predicate;
import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.util.MethodHandleUtils;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.network.play.server.SPacketUnloadChunk;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.StringUtils;

public class ChunkUtils {
    public static final String TAG_CHANGED_CHUNKS = "chunks_changed";
    public static final String TAG_BIOMES_IMPORTED = "biomes_imported";
    public static final String TAG_BIOMES_SET = "biomes_set";
    private static final ChunkUtils INSTANCE = new ChunkUtils();
    private static MethodHandle methodHandle_ChunkProviderServer_saveChunkData = MethodHandleUtils.getMethodHandleVirtual(ChunkProviderServer.class, new String[]{"func_73242_b", "saveChunkData"}, Chunk.class);
    private static MethodHandle methodHandle_ChunkProviderServer_saveChunkExtraData = MethodHandleUtils.getMethodHandleVirtual(ChunkProviderServer.class, new String[]{"func_73243_a", "saveChunkExtraData"}, Chunk.class);
    private static Field field_World_tileEntitiesToBeRemoved = ReflectionHelper.findField(World.class, (String[])new String[]{"field_147483_b", "tileEntitiesToBeRemoved"});
    private static Field field_World_unloadedEntityList = ReflectionHelper.findField(World.class, (String[])new String[]{"field_72997_g", "unloadedEntityList"});
    private static Field field_PlayerChunkMapEntry_chunk = ReflectionHelper.findField(PlayerChunkMapEntry.class, (String[])new String[]{"field_187286_f", "chunk"});
    private final Map<File, AnvilChunkLoader> chunkLoaders = new HashMap<File, AnvilChunkLoader>();
    private final TIntObjectHashMap<Map<String, Map<Long, String>>> changedChunks = new TIntObjectHashMap();
    private final TIntObjectHashMap<Map<String, Map<Long, String>>> importedBiomes = new TIntObjectHashMap();
    private final TIntObjectHashMap<Map<String, Map<Long, String>>> setBiomes = new TIntObjectHashMap();
    private boolean dirty;

    private ChunkUtils() {
    }

    public static ChunkUtils instance() {
        return INSTANCE;
    }

    private static File getBaseWorldSaveLocation() {
        return DimensionManager.getCurrentSaveRootDirectory();
    }

    private static File getWorldSaveLocation(World world) {
        File dir = ChunkUtils.getBaseWorldSaveLocation();
        if (world.field_73011_w.getSaveFolder() != null) {
            dir = new File(dir, world.field_73011_w.getSaveFolder());
        }
        return dir;
    }

    private static File getAlternateWorldsBaseDirectory() {
        return new File(ChunkUtils.getBaseWorldSaveLocation(), "alternate_worlds");
    }

    private static File getAlternateWorldSaveLocation(World world, String worldName) {
        File baseDir = ChunkUtils.getAlternateWorldsBaseDirectory();
        if (world.field_73011_w.getSaveFolder() != null) {
            baseDir = new File(baseDir, world.field_73011_w.getSaveFolder());
        }
        return new File(baseDir, worldName);
    }

    public static int getNumberOfAlternateWorlds() {
        File dir = ChunkUtils.getAlternateWorldsBaseDirectory();
        String[] names = dir.list();
        int num = 0;
        if (names != null) {
            for (String name : names) {
                File tmp1 = new File(dir, name);
                File tmp2 = new File(tmp1, "region");
                if (!tmp1.isDirectory() || !tmp2.isDirectory()) continue;
                ++num;
            }
            return num;
        }
        return 0;
    }

    public static String getWorldName(int index) {
        File dir = ChunkUtils.getAlternateWorldsBaseDirectory();
        String[] names = dir.list();
        if (names != null) {
            ArrayList<String> namesList = new ArrayList<String>();
            for (String name : names) {
                File tmp1 = new File(dir, name);
                File tmp2 = new File(tmp1, "region");
                if (!tmp1.isDirectory() || !tmp2.isDirectory()) continue;
                namesList.add(name);
            }
            Collections.sort(namesList);
            return index < namesList.size() ? (String)namesList.get(index) : "";
        }
        return "";
    }

    public AnvilChunkLoader getChunkLoader(File worldDir) {
        AnvilChunkLoader loader = this.chunkLoaders.get(worldDir);
        if (loader == null) {
            loader = new AnvilChunkLoader(worldDir, FMLCommonHandler.instance().getMinecraftServerInstance().getDataFixer());
            this.chunkLoaders.put(worldDir, loader);
        }
        return loader;
    }

    public AnvilChunkLoader getChunkLoaderForWorld(World world) {
        File worldDir = ChunkUtils.getWorldSaveLocation(world);
        if (worldDir.exists() && worldDir.isDirectory()) {
            return this.getChunkLoader(worldDir);
        }
        return null;
    }

    public AnvilChunkLoader getChunkLoaderForAlternateWorld(World world, String alternateWorldName) {
        File worldDir = ChunkUtils.getAlternateWorldSaveLocation(world, alternateWorldName);
        if (worldDir.exists() && worldDir.isDirectory()) {
            return this.getChunkLoader(worldDir);
        }
        return null;
    }

    private void unloadChunk(WorldServer world, ChunkPos pos) {
        int chunkX = pos.field_77276_a;
        int chunkZ = pos.field_77275_b;
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        chunk.func_76623_d();
        try {
            ChunkProviderServer provider = world.func_72863_F();
            methodHandle_ChunkProviderServer_saveChunkData.invokeExact(provider, chunk);
            methodHandle_ChunkProviderServer_saveChunkExtraData.invokeExact(provider, chunk);
        }
        catch (Throwable t) {
            WorldUtils.logger.warn("Exception while trying to unload chunk ({}, {})", (Object)chunk.field_76635_g, (Object)chunk.field_76647_h, (Object)t);
        }
        ArrayList unloadEntities = new ArrayList();
        for (ClassInheritanceMultiMap map : chunk.func_177429_s()) {
            unloadEntities.addAll(map);
        }
        for (int i = 0; i < unloadEntities.size(); ++i) {
            Entity entity = (Entity)unloadEntities.get(i);
            if (entity instanceof EntityPlayer) continue;
            world.field_72996_f.remove(entity);
            world.func_72847_b(entity);
        }
        Collection unloadTileEntities = chunk.func_177434_r().values();
        world.field_175730_i.removeAll(unloadTileEntities);
        world.field_147482_g.removeAll(unloadTileEntities);
        try {
            List toRemove = (List)field_World_tileEntitiesToBeRemoved.get(world);
            toRemove.removeAll(unloadTileEntities);
            List toRemoveEnt = (List)field_World_unloadedEntityList.get(world);
            toRemoveEnt.removeAll(unloadEntities);
        }
        catch (Exception e) {
            WorldUtils.logger.warn("Exception while trying to unload chunk ({}, {})", (Object)chunk.field_76635_g, (Object)chunk.field_76647_h, (Object)e);
        }
        StructureBoundingBox bb = new StructureBoundingBox(chunkX << 4, 0, chunkZ << 4, (chunkX << 4) + 17, 255, (chunkZ << 4) + 17);
        world.func_175712_a(bb, true);
        world.func_72863_F().field_73244_f.remove(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h));
    }

    private Chunk loadChunk(WorldServer world, ChunkPos pos, String worldName) {
        AnvilChunkLoader loader = this.getChunkLoaderForAlternateWorld((World)world, worldName);
        if (loader != null) {
            try {
                Object[] data = loader.loadChunk__Async((World)world, pos.field_77276_a, pos.field_77275_b);
                if (data != null) {
                    this.unloadChunk(world, pos);
                    final Chunk chunk = (Chunk)data[0];
                    NBTTagCompound nbt = (NBTTagCompound)data[1];
                    loader.loadEntities((World)world, nbt.func_74775_l("Level"), chunk);
                    chunk.func_177432_b(world.func_82737_E());
                    world.func_72863_F().field_73244_f.put(ChunkPos.func_77272_a((int)pos.field_77276_a, (int)pos.field_77275_b), (Object)chunk);
                    this.updatePlayerChunkMap(world, pos, chunk);
                    ArrayList unloadEntities = new ArrayList();
                    for (ClassInheritanceMultiMap map : chunk.func_177429_s()) {
                        unloadEntities.addAll(map);
                    }
                    for (Entity entity : unloadEntities) {
                        Entity match = world.func_175733_a(entity.func_110124_au());
                        if (match == null) continue;
                        world.func_72973_f(match);
                    }
                    chunk.func_76631_c();
                    chunk.func_76630_e();
                    for (EntityPlayerMP player : world.func_175661_b(EntityPlayerMP.class, (Predicate)new Predicate<EntityPlayerMP>(){

                        public boolean apply(EntityPlayerMP playerIn) {
                            double x = chunk.field_76635_g << 4;
                            double z = chunk.field_76647_h << 4;
                            return playerIn.field_70165_t >= x && playerIn.field_70165_t < x + 16.0 && playerIn.field_70161_v >= z && playerIn.field_70161_v < z + 16.0;
                        }
                    })) {
                        chunk.func_76612_a((Entity)player);
                    }
                    return chunk;
                }
            }
            catch (IOException e) {
                WorldUtils.logger.warn("Exception while trying to load chunk ({}, {}) - IOException", (Object)pos.field_77276_a, (Object)pos.field_77275_b);
            }
        }
        return null;
    }

    private void updatePlayerChunkMap(WorldServer world, ChunkPos pos, Chunk chunk) {
        PlayerChunkMap map = world.func_184164_w();
        PlayerChunkMapEntry entry = map.func_187301_b(pos.field_77276_a, pos.field_77275_b);
        if (entry != null) {
            try {
                field_PlayerChunkMapEntry_chunk.set(entry, chunk);
            }
            catch (Exception e) {
                WorldUtils.logger.warn("Failed to update PlayerChunkMapEntry for chunk ({}, {})", (Object)pos.field_77276_a, (Object)pos.field_77275_b, (Object)e);
            }
        }
    }

    private void sendChunkToWatchers(final WorldServer world, final Chunk chunk) {
        for (EntityPlayerMP player : world.func_175661_b(EntityPlayerMP.class, (Predicate)new Predicate<EntityPlayerMP>(){

            public boolean apply(EntityPlayerMP playerIn) {
                return world.func_184164_w().func_72694_a(playerIn, chunk.field_76635_g, chunk.field_76647_h);
            }
        })) {
            player.field_71135_a.func_147359_a((Packet)new SPacketUnloadChunk(chunk.field_76635_g, chunk.field_76647_h));
            SPacketChunkData packet = new SPacketChunkData(chunk, 65535);
            player.field_71135_a.func_147359_a((Packet)packet);
            world.func_73039_n().func_85172_a(player, chunk);
        }
    }

    private Map<String, Map<Long, String>> getChangeMap(TIntObjectHashMap<Map<String, Map<Long, String>>> mainMap, World world) {
        int dim = world.field_73011_w.getDimension();
        HashMap map = (HashMap)mainMap.get(dim);
        if (map == null) {
            map = new HashMap();
            mainMap.put(dim, map);
        }
        return map;
    }

    private void addChangedChunkLocation(World world, ChunkPos pos, ChangeType type, String worldName, String user) {
        Map<String, Map<Long, String>> mainMap = null;
        mainMap = type == ChangeType.CHUNK_CHANGE ? this.getChangeMap(this.changedChunks, world) : (type == ChangeType.BIOME_IMPORT ? this.getChangeMap(this.importedBiomes, world) : this.getChangeMap(this.setBiomes, world));
        Map<Long, String> map = mainMap.get(user);
        if (map == null) {
            map = new HashMap<Long, String>();
            mainMap.put(user, map);
        }
        Long posLong = ChunkPos.func_77272_a((int)pos.field_77276_a, (int)pos.field_77275_b);
        map.put(posLong, worldName);
        if (type == ChangeType.CHUNK_CHANGE) {
            map = this.getChangeMap(this.importedBiomes, world).get(user);
            if (map != null) {
                map.remove(posLong);
            }
            if ((map = this.getChangeMap(this.setBiomes, world).get(user)) != null) {
                map.remove(posLong);
            }
        }
        this.dirty = true;
    }

    public void readFromDisk(World world) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        try {
            String[] files;
            File saveDir = ChunkUtils.getAlternateWorldsBaseDirectory();
            if (saveDir == null || !saveDir.isDirectory()) {
                return;
            }
            final int dim = world.field_73011_w.getDimension();
            for (String fileName : files = saveDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("dim" + dim + "_") && name.endsWith("_changed_chunks.nbt");
                }
            })) {
                File file = new File(saveDir, fileName);
                if (!file.exists() || !file.isFile()) continue;
                NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
                this.readFromNBT(this.getChangeMap(this.changedChunks, world), nbt, TAG_CHANGED_CHUNKS);
                this.readFromNBT(this.getChangeMap(this.importedBiomes, world), nbt, TAG_BIOMES_IMPORTED);
                this.readFromNBT(this.getChangeMap(this.setBiomes, world), nbt, TAG_BIOMES_SET);
            }
        }
        catch (Exception e) {
            WorldUtils.logger.warn("Failed to read exported changed chunks data from file!");
        }
    }

    public void writeToDisk(World world) {
        if (!this.dirty || !(world instanceof WorldServer)) {
            return;
        }
        try {
            File saveDir = ChunkUtils.getAlternateWorldsBaseDirectory();
            if (saveDir == null || !saveDir.exists() && !saveDir.mkdirs()) {
                WorldUtils.logger.warn("Failed to create the directory '" + saveDir + "'");
                return;
            }
            int dim = world.field_73011_w.getDimension();
            for (String user : this.getChangeMap(this.changedChunks, world).keySet()) {
                String fileName = "dim" + dim + "_" + user + "_changed_chunks.nbt";
                File fileTmp = new File(saveDir, fileName + ".tmp");
                File fileReal = new File(saveDir, fileName);
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeToNBT(world, user), (OutputStream)new FileOutputStream(fileTmp));
                if (fileReal.exists()) {
                    fileReal.delete();
                }
                fileTmp.renameTo(fileReal);
            }
            this.dirty = false;
        }
        catch (Exception e) {
            WorldUtils.logger.warn("Failed to write exported changed chunks data to file!");
        }
    }

    private void readFromNBT(Map<String, Map<Long, String>> mapIn, NBTTagCompound nbt, String tagName) {
        if (nbt == null || StringUtils.isBlank((CharSequence)nbt.func_74779_i("user"))) {
            return;
        }
        HashMap<Long, String> chunks = new HashMap<Long, String>();
        NBTTagList list = nbt.func_150295_c(tagName, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            String worldName = tag.func_74779_i("world");
            int[] arr = tag.func_74759_k("chunks");
            for (int j = 0; j < arr.length - 1; j += 2) {
                long loc = (long)arr[j + 1] << 32 | (long)arr[j];
                chunks.put(loc, worldName);
            }
        }
        String user = nbt.func_74779_i("user");
        mapIn.put(user, chunks);
        WorldUtils.logger.info("ChunkChanger: Read {} stored chunk modifications of type '{}' from file for user {}", (Object)chunks.size(), (Object)tagName, (Object)user);
    }

    public NBTTagCompound writeToNBT(World world, String user) {
        NBTTagCompound nbt = new NBTTagCompound();
        int dim = world.field_73011_w.getDimension();
        this.writeToNBT(this.getChangeMap(this.changedChunks, world), dim, user, nbt, TAG_CHANGED_CHUNKS);
        this.writeToNBT(this.getChangeMap(this.importedBiomes, world), dim, user, nbt, TAG_BIOMES_IMPORTED);
        this.writeToNBT(this.getChangeMap(this.setBiomes, world), dim, user, nbt, TAG_BIOMES_SET);
        return nbt;
    }

    private NBTTagCompound writeToNBT(Map<String, Map<Long, String>> mapIn, int dimension, String user, NBTTagCompound nbt, String tagName) {
        Map<Long, String> modifiedChunks = mapIn.get(user);
        if (modifiedChunks == null) {
            return nbt;
        }
        HashMap<String, ArrayList<Long>> changesPerWorld = new HashMap<String, ArrayList<Long>>();
        for (Map.Entry<Long, String> entry : modifiedChunks.entrySet()) {
            String worldName = entry.getValue();
            ArrayList<Long> locations = (ArrayList<Long>)changesPerWorld.get(worldName);
            if (locations == null) {
                locations = new ArrayList<Long>();
                changesPerWorld.put(worldName, locations);
            }
            locations.add(entry.getKey());
        }
        NBTTagList list = new NBTTagList();
        for (Map.Entry entry : changesPerWorld.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("world", (String)entry.getKey());
            List chunks = (List)entry.getValue();
            int[] chunksArr = new int[chunks.size() * 2];
            int i = 0;
            Iterator iterator = chunks.iterator();
            while (iterator.hasNext()) {
                long chunk = (Long)iterator.next();
                chunksArr[i] = (int)(chunk & 0xFFFFFFFFFFFFFFFFL);
                chunksArr[i + 1] = (int)(chunk >>> 32);
                i += 2;
            }
            tag.func_74783_a("chunks", chunksArr);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74778_a("user", user);
        nbt.func_74768_a("dim", dimension);
        nbt.func_74782_a(tagName, (NBTBase)list);
        return nbt;
    }

    public void loadBiomesFromAlternateWorld(World worldIn, ChunkPos pos, String worldName, String user) {
        if (!(worldIn instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)worldIn;
        if (!StringUtils.isBlank((CharSequence)worldName)) {
            AnvilChunkLoader loader = this.getChunkLoaderForAlternateWorld((World)world, worldName);
            try {
                byte[] biomes;
                NBTTagCompound level;
                NBTTagCompound nbt;
                DataInputStream stream = RegionFileCache.func_76549_c((File)loader.field_75825_d, (int)pos.field_77276_a, (int)pos.field_77275_b);
                if (stream != null && (nbt = CompressedStreamTools.func_74794_a((DataInputStream)stream)) != null && nbt.func_150297_b("Level", 10) && (level = nbt.func_74775_l("Level")).func_150297_b("Biomes", 7) && (biomes = level.func_74770_j("Biomes")).length == 256) {
                    Chunk chunkCurrent = world.func_72964_e(pos.field_77276_a, pos.field_77275_b);
                    chunkCurrent.func_76616_a(biomes);
                    chunkCurrent.func_76630_e();
                    this.sendChunkToWatchers(world, chunkCurrent);
                    this.addChangedChunkLocation((World)world, pos, ChangeType.BIOME_IMPORT, worldName, user);
                }
            }
            catch (IOException e) {
                WorldUtils.logger.warn("Failed to read chunk data for chunk ({}, {})", (Object)pos.field_77276_a, (Object)pos.field_77275_b);
            }
        }
    }

    public void setBiome(World worldIn, ChunkPos pos, Biome biome, String user) {
        if (!(worldIn instanceof WorldServer) || biome == null) {
            return;
        }
        WorldServer world = (WorldServer)worldIn;
        Chunk chunkCurrent = world.func_72964_e(pos.field_77276_a, pos.field_77275_b);
        byte[] biomes = new byte[256];
        Arrays.fill(biomes, (byte)Biome.func_185362_a((Biome)biome));
        chunkCurrent.func_76616_a(biomes);
        chunkCurrent.func_76630_e();
        this.sendChunkToWatchers(world, chunkCurrent);
        this.addChangedChunkLocation((World)world, pos, ChangeType.BIOME_SET, "", user);
    }

    public void loadChunkFromAlternateWorld(World worldIn, ChunkPos pos, String worldName, String user) {
        Chunk chunk;
        if (!(worldIn instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)worldIn;
        if (!StringUtils.isBlank((CharSequence)worldName) && (chunk = this.loadChunk(world, pos, worldName)) != null) {
            this.sendChunkToWatchers(world, world.func_72964_e(pos.field_77276_a, pos.field_77275_b));
            this.addChangedChunkLocation((World)world, pos, ChangeType.CHUNK_CHANGE, worldName, user);
        }
    }

    public void clearChangedChunksForUser(World world, String user) {
        this.getChangeMap(this.changedChunks, world).remove(user);
    }

    public static enum ChangeType {
        CHUNK_CHANGE,
        BIOME_IMPORT,
        BIOME_SET;


        public static ChangeType fromId(int id) {
            return ChangeType.values()[id % ChangeType.values().length];
        }
    }

    public static class ChunkChanges {
        public final ChangeType type;
        public final String worldName;

        public ChunkChanges(ChangeType type, String worldName) {
            this.type = type;
            this.worldName = worldName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.worldName == null ? 0 : this.worldName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChunkChanges other = (ChunkChanges)obj;
            if (this.type != other.type) {
                return false;
            }
            return !(this.worldName == null ? other.worldName != null : !this.worldName.equals(other.worldName));
        }
    }
}

