/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.util;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.data.IChunkDataHandler;
import fi.dy.masa.worldutils.data.IWorldDataHandler;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class FileUtils {
    public static final FilenameFilter ANVIL_REGION_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            try {
                return Pattern.matches("r\\.-?[0-9]+\\.-?[0-9]+\\.mca", name);
            }
            catch (PatternSyntaxException e) {
                WorldUtils.logger.error("Failed to regex match a region file '{}'", (Object)name);
                e.printStackTrace();
                return false;
            }
        }
    };

    public static void worldDataProcessor(int dimension, IWorldDataHandler worldDataHandler, ICommandSender sender, boolean simulate) {
        File regionDir;
        WorldServer world = DimensionManager.getWorld((int)dimension);
        ChunkProviderServer provider = null;
        if (world != null && world.func_72863_F() instanceof ChunkProviderServer) {
            provider = (ChunkProviderServer)world.func_72863_F();
        }
        if ((regionDir = FileUtils.getRegionDirectory(dimension)) != null && regionDir.exists() && regionDir.isDirectory()) {
            worldDataHandler.setChunkProvider(provider);
            for (File regionFile : regionDir.listFiles(ANVIL_REGION_FILE_FILTER)) {
                FileUtils.regionProcessor(regionFile, worldDataHandler, simulate);
            }
            worldDataHandler.finish(sender, simulate);
        } else {
            WorldUtils.logger.warn("Dimension {} could not be loaded or does not exist!", (Object)dimension);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("worldutils.commands.error.invaliddimension", new Object[]{dimension}));
        }
    }

    private static void regionProcessor(File regionFile, IWorldDataHandler worldDataHandler, boolean simulate) {
        Region region = Region.fromRegionFile(regionFile);
        if (region == null) {
            WorldUtils.logger.warn("regionProcessor(): Failed to get region data for region '{}'", (Object)regionFile.getName());
            return;
        }
        if (worldDataHandler.processRegion(region, simulate) == 0) {
            for (int chunkZ = 0; chunkZ < 32; ++chunkZ) {
                for (int chunkX = 0; chunkX < 32; ++chunkX) {
                    if (!region.getRegionFile().func_76709_c(chunkX, chunkZ)) continue;
                    worldDataHandler.processChunk(region, chunkX, chunkZ, simulate);
                }
            }
        }
    }

    public static int handleChunkInRegion(Region region, ChunkPos chunkPos, IChunkDataHandler chunkDataHandler, boolean simulate) {
        int count = 0;
        int chunkX = chunkPos.field_77276_a & 0x1F;
        int chunkZ = chunkPos.field_77275_b & 0x1F;
        RegionFile regionFile = region.getRegionFile();
        if (!regionFile.func_76709_c(chunkX, chunkZ)) {
            WorldUtils.logger.warn("handleChunkInRegion(): Chunk ({}, {}) was not found in region '{}'", (Object)chunkPos.field_77276_a, (Object)chunkPos.field_77275_b, (Object)region.getName());
            return 0;
        }
        DataInputStream data = regionFile.func_76704_a(chunkX, chunkZ);
        if (data == null) {
            WorldUtils.logger.warn("handleChunkInRegion(): Failed to read chunk data for chunk ({}, {}) from region '{}'", (Object)chunkPos.field_77276_a, (Object)chunkPos.field_77275_b, (Object)region.getName());
            return 0;
        }
        try {
            NBTTagCompound chunkNBT = CompressedStreamTools.func_74794_a((DataInputStream)data);
            data.close();
            count = chunkDataHandler.processChunkData(chunkPos, chunkNBT, simulate);
            if (count > 0 && !simulate) {
                DataOutputStream dataOut = regionFile.func_76710_b(chunkX, chunkZ);
                CompressedStreamTools.func_74800_a((NBTTagCompound)chunkNBT, (DataOutput)dataOut);
                dataOut.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return count;
    }

    public static File dumpDataToFile(String fileNameBase, List<String> lines) {
        File outFile = null;
        File cfgDir = new File(WorldUtils.configDirPath);
        if (!cfgDir.exists()) {
            try {
                cfgDir.mkdirs();
            }
            catch (Exception e) {
                WorldUtils.logger.error("dumpDataToFile(): Failed to create the configuration directory.", (Throwable)e);
                return null;
            }
        }
        String fileNameBaseWithDate = fileNameBase + "_" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date(System.currentTimeMillis()));
        String fileName = fileNameBaseWithDate + ".txt";
        outFile = new File(cfgDir, fileName);
        int postFix = 1;
        while (outFile.exists()) {
            fileName = fileNameBaseWithDate + "_" + postFix + ".txt";
            outFile = new File(cfgDir, fileName);
            ++postFix;
        }
        try {
            outFile.createNewFile();
        }
        catch (IOException e) {
            WorldUtils.logger.error("dumpDataToFile(): Failed to create data dump file '" + fileName + "'", (Throwable)e);
            return null;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
            for (int i = 0; i < lines.size(); ++i) {
                writer.write(lines.get(i));
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            WorldUtils.logger.error("dumpDataToFile(): Exception while writing data dump to file '" + fileName + "'", (Throwable)e);
        }
        return outFile;
    }

    @Nullable
    public static File getWorldSaveLocation(int dimension) {
        File dir = DimensionManager.getCurrentSaveRootDirectory();
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
        if (world != null) {
            if (world.field_73011_w.getSaveFolder() != null) {
                return new File(dir, world.field_73011_w.getSaveFolder());
            }
            if (world.field_73011_w.getDimension() == 0) {
                return dir;
            }
        }
        return null;
    }

    @Nullable
    public static File getRegionDirectory(int dimension) {
        File worldDir = FileUtils.getWorldSaveLocation(dimension);
        if (worldDir != null) {
            return new File(worldDir, "region");
        }
        return null;
    }

    public static class Region {
        private final String regionName;
        private final File file;
        private final RegionFile regionFile;

        private Region(File worldDir, int regionX, int regionZ, boolean create) {
            this.file = new File(new File(worldDir, "region"), "r." + regionX + "." + regionZ + ".mca");
            this.regionName = this.file.getName();
            this.regionFile = create ? RegionFileCache.func_76550_a((File)worldDir, (int)(regionX << 5), (int)(regionZ << 5)) : RegionFileCache.func_191065_b((File)worldDir, (int)(regionX << 5), (int)(regionZ << 5));
        }

        public static Region fromRegionFile(File regionFile) {
            ChunkPos regionPos = Region.getRegionPos(regionFile);
            if (regionPos != null) {
                return Region.fromRegionCoords(regionFile.getParentFile().getParentFile(), regionPos.field_77276_a, regionPos.field_77275_b);
            }
            return null;
        }

        public static Region fromRegionCoords(File worldDir, ChunkPos regionPos) {
            return Region.fromRegionCoords(worldDir, regionPos.field_77276_a, regionPos.field_77275_b);
        }

        public static Region fromRegionCoords(File worldDir, int regionX, int regionZ) {
            return Region.fromRegionCoords(worldDir, regionX, regionZ, true);
        }

        public static Region fromRegionCoords(File worldDir, int regionX, int regionZ, boolean create) {
            return new Region(worldDir, regionX, regionZ, create);
        }

        public String getName() {
            return this.regionName;
        }

        public String getFileName() {
            return this.file.getAbsolutePath();
        }

        @Nullable
        public RegionFile getRegionFile() {
            return this.regionFile;
        }

        public static ChunkPos getRegionPos(File regionFile) {
            String name = regionFile.getName();
            if (ANVIL_REGION_FILE_FILTER.accept(regionFile.getParentFile(), name)) {
                try {
                    Pattern pattern = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
                    Matcher matcher = pattern.matcher(name);
                    if (matcher.matches()) {
                        int x = Integer.valueOf(matcher.group(1));
                        int z = Integer.valueOf(matcher.group(2));
                        return new ChunkPos(x, z);
                    }
                }
                catch (Exception e) {
                    WorldUtils.logger.error("getRegionPos(): Failed to regex match a region file '{}'", (Object)name);
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

