/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.util;

import fi.dy.masa.worldutils.WorldUtils;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTFormatter {
    public static final String[] TAG_NAMES = new String[]{"TAG_End", "TAG_Byte", "TAG_Short", "TAG_Int", "TAG_Long", "TAG_Float", "TAG_Double", "TAG_Byte_Array", "TAG_String", "TAG_List", "TAG_Compound", "TAG_Int_Array"};

    private static String getTagName(int id) {
        if (id >= 0 && id < TAG_NAMES.length) {
            return TAG_NAMES[id];
        }
        return "";
    }

    private static String getTagDescription(int id, String name) {
        return NBTFormatter.getTagName(id) + String.format(" (%d) ('%s')", id, name);
    }

    private static void getPrettyFormattedLine(List<String> lines, NBTBase nbt, String name, int depth) {
        int len = 0;
        String pre = "";
        String pre2 = "";
        try {
            String fmt = String.format("%%-%ds", depth * 4);
            if (depth > 0) {
                pre = String.format(fmt, "");
            }
            fmt = String.format("%%%ds", depth * 4 + 3);
            pre2 = String.format(fmt, "");
        }
        catch (IllegalFormatException e) {
            WorldUtils.logger.warn("Error while printing NBT data");
        }
        switch (nbt.func_74732_a()) {
            case 0: {
                lines.add(pre + "}");
                break;
            }
            case 1: {
                lines.add(pre + NBTFormatter.getTagDescription(nbt.func_74732_a(), name) + ": " + ((NBTTagByte)nbt).func_150290_f());
                break;
            }
            case 2: {
                lines.add(pre + NBTFormatter.getTagDescription(nbt.func_74732_a(), name) + ": " + ((NBTTagShort)nbt).func_150289_e());
                break;
            }
            case 3: {
                lines.add(pre + NBTFormatter.getTagDescription(nbt.func_74732_a(), name) + ": " + ((NBTTagInt)nbt).func_150287_d());
                break;
            }
            case 4: {
                lines.add(pre + NBTFormatter.getTagDescription(nbt.func_74732_a(), name) + ": " + ((NBTTagLong)nbt).func_150291_c());
                break;
            }
            case 5: {
                lines.add(pre + NBTFormatter.getTagDescription(nbt.func_74732_a(), name) + ": " + ((NBTTagFloat)nbt).func_150288_h());
                break;
            }
            case 6: {
                lines.add(pre + NBTFormatter.getTagDescription(nbt.func_74732_a(), name) + ": " + ((NBTTagDouble)nbt).func_150286_g());
                break;
            }
            case 7: {
                byte[] arrByte = ((NBTTagByteArray)nbt).func_150292_c();
                len = arrByte.length;
                lines.add(pre + NBTFormatter.getTagDescription(nbt.func_74732_a(), name) + " (" + len + " values)");
                if (len <= 16) {
                    for (int pos = 0; pos < len; ++pos) {
                        lines.add(pre2 + String.format("    %2d: 0x%02X (%4d)", pos, arrByte[pos], arrByte[pos]));
                    }
                } else {
                    int pos = 0;
                    while (pos < len) {
                        StringBuilder sb = new StringBuilder(256);
                        String line = pre2 + String.format("    %4d:", pos);
                        sb.append(line);
                        for (int i = 0; i < 8 && pos < len; ++i, ++pos) {
                            sb.append(String.format(" 0x%02X (%4d)", arrByte[pos], arrByte[pos]));
                        }
                        lines.add(sb.toString());
                    }
                }
                break;
            }
            case 8: {
                lines.add(pre + NBTFormatter.getTagDescription(nbt.func_74732_a(), name) + ": " + ((NBTTagString)nbt).toString());
                break;
            }
            case 9: {
                NBTTagList tagList = (NBTTagList)nbt;
                int tagCount = tagList.func_74745_c();
                int tagType = tagList.func_150303_d();
                lines.add(pre + NBTFormatter.getTagDescription(nbt.func_74732_a(), name) + " (" + tagCount + " entries of " + NBTFormatter.getTagName(tagType) + " (" + tagType + "))");
                lines.add(pre + "{");
                for (int i = 0; i < tagCount; ++i) {
                    NBTFormatter.getPrettyFormattedLine(lines, tagList.func_179238_g(i), "", depth + 1);
                }
                lines.add(pre + "}");
                break;
            }
            case 10: {
                lines.add(pre + NBTFormatter.getTagDescription(nbt.func_74732_a(), name));
                lines.add(pre + "{");
                NBTTagCompound tag = (NBTTagCompound)nbt;
                Set keys = tag.func_150296_c();
                for (String key : keys) {
                    NBTFormatter.getPrettyFormattedLine(lines, tag.func_74781_a(key), key, depth + 1);
                }
                lines.add(pre + "}");
                break;
            }
            case 11: {
                int[] arrInt = ((NBTTagIntArray)nbt).func_150302_c();
                len = arrInt.length;
                lines.add(pre + NBTFormatter.getTagDescription(nbt.func_74732_a(), name) + " (" + len + " values)");
                if (len <= 16) {
                    for (int pos = 0; pos < len; ++pos) {
                        lines.add(pre2 + String.format("    %2d: 0x%08X (%11d)", pos, arrInt[pos], arrInt[pos]));
                    }
                } else {
                    int pos = 0;
                    while (pos < len) {
                        StringBuilder sb = new StringBuilder(256);
                        String line = pre2 + String.format("    %4d:", pos);
                        sb.append(line);
                        for (int i = 0; i < 4 && pos < len; ++i, ++pos) {
                            sb.append(String.format(" 0x%08X (%11d)", arrInt[pos], arrInt[pos]));
                        }
                        lines.add(sb.toString());
                    }
                }
                break;
            }
        }
    }

    public static void getPrettyFormattedNBT(List<String> lines, NBTTagCompound nbt) {
        if (nbt != null) {
            NBTFormatter.getPrettyFormattedLine(lines, (NBTBase)nbt, "", 0);
        }
    }
}

