/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.util;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NBTUtils {
    public static ItemStack setRootCompoundTag(ItemStack stack, NBTTagCompound nbt) {
        if (nbt != null && nbt.func_82582_d()) {
            nbt = null;
        }
        stack.func_77982_d(nbt);
        return stack;
    }

    public static NBTTagCompound getRootCompoundTag(ItemStack stack, boolean create) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (!create) {
            return nbt;
        }
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    public static NBTTagCompound getCompoundTag(NBTTagCompound nbt, String tagName, boolean create) {
        if (nbt == null) {
            return null;
        }
        if (!create) {
            return nbt.func_150297_b(tagName, 10) ? nbt.func_74775_l(tagName) : null;
        }
        if (!nbt.func_150297_b(tagName, 10)) {
            nbt.func_74782_a(tagName, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tagName);
    }

    public static NBTTagCompound getCompoundTag(ItemStack stack, String tagName, boolean create) {
        NBTTagCompound nbt = NBTUtils.getRootCompoundTag(stack, create);
        if (tagName != null) {
            nbt = NBTUtils.getCompoundTag(nbt, tagName, create);
        }
        return nbt;
    }

    public static byte getByte(ItemStack stack, String containerTagName, String tagName) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, false);
        return nbt != null ? nbt.func_74771_c(tagName) : (byte)0;
    }

    public static void setByte(ItemStack stack, String containerTagName, String tagName, byte value) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        nbt.func_74774_a(tagName, value);
    }

    public static void cycleByteValue(NBTTagCompound nbt, String tagName, int minValue, int maxValue) {
        NBTUtils.cycleByteValue(nbt, tagName, minValue, maxValue, false);
    }

    public static void cycleByteValue(NBTTagCompound nbt, String tagName, int minValue, int maxValue, boolean reverse) {
        byte value = nbt.func_74771_c(tagName);
        if (reverse) {
            if ((value = (byte)(value - 1)) < minValue) {
                value = (byte)maxValue;
            }
        } else if ((value = (byte)(value + 1)) > maxValue) {
            value = (byte)minValue;
        }
        nbt.func_74774_a(tagName, value);
    }

    public static void cycleByteValue(ItemStack stack, String containerTagName, String tagName, int maxValue) {
        NBTUtils.cycleByteValue(stack, containerTagName, tagName, maxValue, false);
    }

    public static void cycleByteValue(ItemStack stack, String containerTagName, String tagName, int maxValue, boolean reverse) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        NBTUtils.cycleByteValue(nbt, tagName, 0, maxValue, reverse);
    }

    public static void cycleByteValue(ItemStack stack, String containerTagName, String tagName, int minValue, int maxValue, boolean reverse) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, containerTagName, true);
        NBTUtils.cycleByteValue(nbt, tagName, minValue, maxValue, reverse);
    }
}

