/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldutils.util;

import fi.dy.masa.worldutils.WorldUtils;
import fi.dy.masa.worldutils.util.MethodHandleUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public class RegistryUtils {
    private static MethodHandle methodHandle_ForgeRegistry_isDummied;

    public static <K extends IForgeRegistryEntry<K>> boolean isDummied(IForgeRegistry<K> registry, ResourceLocation rl) {
        try {
            return methodHandle_ForgeRegistry_isDummied.invoke(registry, rl);
        }
        catch (Throwable t) {
            WorldUtils.logger.error("RegistryUtils: Error while trying invoke ForgeRegistry#isDummied()", t);
            return false;
        }
    }

    public static void removeDummyBlocksFromRegistry(String fileName, ICommandSender sender) {
        File file = StringUtils.isBlank((CharSequence)fileName) ? new File(WorldUtils.configDirPath, "level.dat") : new File(WorldUtils.configDirPath, fileName);
        if (file.exists() && file.isFile()) {
            try {
                NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
                if (nbt != null) {
                    NBTTagCompound tag = nbt.func_74775_l("FML").func_74775_l("Registries").func_74775_l(GameData.BLOCKS.toString());
                    if (tag.func_82582_d()) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("worldutils.commands.registrycleanup.error.tagsnotfound", new Object[0]));
                        return;
                    }
                    IForgeRegistry registry = ForgeRegistries.BLOCKS;
                    NBTTagList list = tag.func_150295_c("ids", 10);
                    int size = list.func_74745_c();
                    int count = 0;
                    for (int i = 0; i < size; ++i) {
                        String key;
                        ResourceLocation rl;
                        NBTTagCompound tmp = list.func_150305_b(i);
                        if (!tmp.func_150297_b("K", 8) || registry.containsKey(rl = new ResourceLocation(key = tmp.func_74779_i("K"))) && !RegistryUtils.isDummied(registry, rl)) continue;
                        WorldUtils.logger.info("Removing missing or dummied block registry entry '{}'", (Object)key);
                        list.func_74744_a(i);
                        --i;
                        ++count;
                    }
                    tag.func_74782_a("dummied", (NBTBase)new NBTTagList());
                    if (count > 0) {
                        CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)new FileOutputStream(file));
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("worldutils.commands.registrycleanup.info.complete", new Object[]{count, file.getName()}));
                    WorldUtils.logger.info("Removed {} missing or dummied block entries from the registry in '{}'", (Object)count, (Object)file.getName());
                }
            }
            catch (IOException e) {
                WorldUtils.logger.info("Exception while trying to remove dummied block entries from the registry", (Throwable)e);
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("worldutils.commands.registrycleanup.error.filenotfound", new Object[]{file.getName()}));
        }
    }

    static {
        try {
            methodHandle_ForgeRegistry_isDummied = MethodHandleUtils.getMethodHandleVirtual(ForgeRegistry.class, new String[]{"isDummied"}, ResourceLocation.class);
        }
        catch (MethodHandleUtils.UnableToFindMethodHandleException e) {
            WorldUtils.logger.error("RegistryUtils: Failed to get MethodHandle for ForgeRegistry#isDummied()", (Throwable)e);
        }
    }
}

