/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mpbasic.client.gui;

import com.gendeathrow.mpbasic.core.MPBSettings;
import com.gendeathrow.mputils.core.MPUtils;
import com.gendeathrow.mputils.utils.MPFileUtils;
import com.gendeathrow.mputils.utils.MPInfo;
import com.gendeathrow.mputils.utils.Tools;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.opengl.Display;

public class BugReporterWindow {
    public JFrame frame;
    public JTextField textField;
    private final JFileChooser fc = new JFileChooser();
    private JTextField titlefield;
    private JTextArea descriptiontextArea;
    private List<String> list;
    private JCheckBox gistCheckBox;
    private JTextArea resultTextArea;
    private JTextArea generatedReport;
    private JTextField emailField;

    public static void main(String[] args) {
        BugReporterWindow window = new BugReporterWindow();
        window.frame.setVisible(true);
    }

    public BugReporterWindow() {
        this.initialize();
    }

    private void initialize() {
        long i = Runtime.getRuntime().maxMemory();
        long j = Runtime.getRuntime().totalMemory();
        long k = Runtime.getRuntime().freeMemory();
        long l = j - k;
        this.list = Lists.newArrayList((Object[])new String[]{String.format("%s %dbit", System.getProperty("java.version"), Minecraft.func_71410_x().func_147111_S() ? 64 : 32), String.format("% 2d%% %03d/%03dMB", l * 100L / i, BugReporterWindow.bytesToMb(l), BugReporterWindow.bytesToMb(i)), String.format("% 2d%% %03dMB", j * 100L / i, BugReporterWindow.bytesToMb(j)), "", String.format("%s", OpenGlHelper.func_183029_j()), "", String.format("%dx%d (%s)", Display.getWidth(), Display.getHeight(), GlStateManager.func_187416_u((int)7936)), GlStateManager.func_187416_u((int)7937), GlStateManager.func_187416_u((int)7938)});
        this.frame = new JFrame();
        this.frame.setBounds(100, 100, 654, 577);
        final JPanel panelForum = new JPanel();
        panelForum.setVisible(false);
        this.frame.getContentPane().setLayout(new CardLayout(0, 0));
        this.frame.getContentPane().add((Component)panelForum, "name_286846318537830");
        panelForum.setLayout(null);
        final JPanel panelOption = new JPanel();
        this.frame.getContentPane().add((Component)panelOption, "name_286846332259221");
        panelOption.setLayout(null);
        final JPanel panelResult = new JPanel();
        this.frame.getContentPane().add((Component)panelResult, "name_289038900546144");
        panelResult.setLayout(null);
        JButton cpclip = new JButton("Copy to Clipboard");
        cpclip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Tools.CopytoClipbard((String)BugReporterWindow.this.generatedReport.getText());
            }
        });
        cpclip.setBounds(234, 368, 184, 23);
        panelOption.add(cpclip);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(56, 37, 529, 320);
        panelOption.add(scrollPane);
        this.generatedReport = new JTextArea();
        this.generatedReport.setEditable(false);
        this.generatedReport.setLineWrap(true);
        scrollPane.setViewportView(this.generatedReport);
        JButton btnNewButton = new JButton("Go to Issue Tracker");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugReporterWindow.goToHttp(MPBSettings.issuetrackerURL);
            }
        });
        btnNewButton.setBounds(224, 491, 216, 23);
        panelOption.add(btnNewButton);
        JTextArea txtrCopyReport = new JTextArea();
        txtrCopyReport.setFont(new Font("Times New Roman", 0, 12));
        txtrCopyReport.setText("1.Click \"Copy Report to Clipboard\"\r\n\r\n2. Click \"Go to Issue Tracker\"\r\n\r\n3. Follow instructions for pasing your Issue.");
        txtrCopyReport.setBackground(SystemColor.activeCaptionBorder);
        txtrCopyReport.setEditable(false);
        txtrCopyReport.setLineWrap(true);
        txtrCopyReport.setBounds(224, 402, 263, 82);
        panelOption.add(txtrCopyReport);
        JLabel label = new JLabel("Title:");
        label.setBounds(10, 151, 46, 14);
        panelForum.add(label);
        JLabel label_1 = new JLabel("Description:");
        label_1.setBounds(10, 176, 62, 14);
        panelForum.add(label_1);
        JLabel igntext = new JLabel("IGN: " + Minecraft.func_71410_x().func_110432_I().func_111285_a());
        igntext.setBounds(10, 11, 271, 14);
        panelForum.add(igntext);
        JLabel forgeversiontext = new JLabel("Forge Verison: " + ForgeVersion.getVersion());
        forgeversiontext.setBounds(10, 36, 271, 14);
        panelForum.add(forgeversiontext);
        JLabel packversiontext = new JLabel("Pack Version: " + MPInfo.version);
        packversiontext.setBounds(10, 61, 271, 14);
        panelForum.add(packversiontext);
        JLabel ostext = new JLabel("OS: " + System.getProperty("os.name"));
        ostext.setBounds(308, 11, 328, 14);
        panelForum.add(ostext);
        JLabel modsloaded = new JLabel("Mods Loaded: " + Loader.instance().getActiveModList().size());
        modsloaded.setBounds(308, 36, 328, 14);
        panelForum.add(modsloaded);
        this.titlefield = new JTextField();
        this.titlefield.setText("Add Title");
        this.titlefield.setColumns(10);
        this.titlefield.setBounds(40, 148, 337, 20);
        panelForum.add(this.titlefield);
        JScrollPane desciptionpane = new JScrollPane();
        desciptionpane.setViewportBorder(new BevelBorder(1, null, null, null, null));
        desciptionpane.setVerticalScrollBarPolicy(22);
        desciptionpane.setBounds(10, 201, 598, 186);
        panelForum.add(desciptionpane);
        this.descriptiontextArea = new JTextArea();
        this.descriptiontextArea.setLineWrap(true);
        desciptionpane.setViewportView(this.descriptiontextArea);
        JSeparator separator = new JSeparator();
        separator.setBounds(10, 138, 586, 2);
        panelForum.add(separator);
        JButton button = new JButton("Next");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MPBSettings.sendJsonData) {
                    BugReporterWindow.this.sendData();
                    panelResult.setVisible(true);
                } else {
                    BugReporterWindow.this.createReport();
                    panelOption.setVisible(true);
                }
                panelForum.setVisible(false);
            }
        });
        button.setBounds(344, 502, 91, 23);
        panelForum.add(button);
        JButton button_1 = new JButton("Cancel");
        button_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BugReporterWindow.this.frame.dispose();
            }
        });
        button_1.setBounds(163, 502, 91, 23);
        panelForum.add(button_1);
        final JLabel nofiletext = new JLabel("No File");
        Border paddingBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        Border border = BorderFactory.createLineBorder(Color.WHITE);
        nofiletext.setBorder(BorderFactory.createCompoundBorder(border, paddingBorder));
        nofiletext.setBounds(151, 398, 445, 23);
        panelForum.add(nofiletext);
        JButton selectlog = new JButton("Select Crash Log");
        selectlog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugReporterWindow.this.fc.setCurrentDirectory(new File("crash-reports"));
                int returnVal = BugReporterWindow.this.fc.showOpenDialog(BugReporterWindow.this.fc);
                if (returnVal == 0) {
                    File file = BugReporterWindow.this.fc.getSelectedFile();
                    nofiletext.setText(BugReporterWindow.this.fc.getSelectedFile().getName());
                }
            }
        });
        selectlog.setBounds(20, 398, 121, 23);
        panelForum.add(selectlog);
        JLabel lblJava = new JLabel("Java: " + this.list.get(0));
        lblJava.setBounds(10, 88, 271, 14);
        panelForum.add(lblJava);
        JLabel lblNewLabel = new JLabel("Mem: " + this.list.get(1));
        lblNewLabel.setBounds(308, 61, 328, 14);
        panelForum.add(lblNewLabel);
        JLabel lblAllocated = new JLabel("Allocated: " + this.list.get(2));
        lblAllocated.setBounds(308, 88, 328, 14);
        panelForum.add(lblAllocated);
        JLabel lblCpu = new JLabel("CPU: " + this.list.get(4));
        lblCpu.setBounds(10, 113, 271, 14);
        panelForum.add(lblCpu);
        JLabel lblDisplay = new JLabel("Display: " + this.list.get(7));
        lblDisplay.setBounds(308, 113, 328, 14);
        panelForum.add(lblDisplay);
        this.gistCheckBox = new JCheckBox("Create Gist Link for Log");
        this.gistCheckBox.setSelected(MPBSettings.crashlogsToGist);
        this.gistCheckBox.setActionCommand("createGist");
        this.gistCheckBox.setBounds(151, 428, 226, 23);
        if (MPBSettings.sendJsonData) {
            this.gistCheckBox.setSelected(false);
            this.gistCheckBox.setEnabled(false);
        }
        panelForum.add(this.gistCheckBox);
        this.emailField = new JTextField();
        this.emailField.setText("example@example.com");
        this.emailField.setBounds(151, 458, 290, 20);
        panelForum.add(this.emailField);
        this.emailField.setColumns(10);
        JLabel lblEnmail = new JLabel("Contact Info:");
        lblEnmail.setBounds(69, 461, 72, 14);
        panelForum.add(lblEnmail);
        if (!MPBSettings.sendJsonData || !MPBSettings.collectEmails) {
            this.emailField.setVisible(false);
            lblEnmail.setVisible(false);
        }
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setBounds(0, 0, 4, 4);
        panelResult.add(scrollPane_1);
        this.resultTextArea = new JTextArea();
        this.resultTextArea.setBackground(SystemColor.activeCaptionBorder);
        this.resultTextArea.setFont(new Font("Times New Roman", 0, 13));
        this.resultTextArea.setEditable(false);
        this.resultTextArea.setLineWrap(true);
        this.resultTextArea.setBounds(67, 47, 511, 370);
        panelResult.add(this.resultTextArea);
        JButton thankyoubutton = new JButton("Thank You");
        thankyoubutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugReporterWindow.this.frame.dispose();
            }
        });
        thankyoubutton.setBounds(233, 461, 177, 23);
        panelResult.add(thankyoubutton);
        this.frame.setDefaultCloseOperation(2);
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public void sendData() {
        JsonObject postData = new JsonObject();
        postData.addProperty("title", this.titlefield.getText());
        postData.addProperty("desc", this.descriptiontextArea.getText());
        postData.addProperty("ign", Minecraft.func_71410_x().func_110432_I().func_111285_a());
        postData.addProperty("email", this.emailField.getText());
        postData.addProperty("forgeVersion", ForgeVersion.getVersion());
        postData.addProperty("mcVersion", "1.12.2");
        postData.addProperty("mpVersion", MPInfo.version);
        postData.addProperty("os", System.getProperty("os.name"));
        postData.addProperty("java", this.list.get(0));
        postData.addProperty("cpu", this.list.get(4));
        postData.addProperty("gpu", this.list.get(7));
        postData.addProperty("mem", this.list.get(1));
        postData.addProperty("allocated", this.list.get(2));
        postData.addProperty("modsLoaded", (Number)Loader.instance().getActiveModList().size());
        if (this.fc.getSelectedFile() != null && this.fc.getSelectedFile().exists()) {
            try {
                postData.addProperty("crashLogFile", this.fc.getSelectedFile().getName());
                String data = MPFileUtils.readFile((String)this.fc.getSelectedFile().getPath());
                if (MPBSettings.crashlogsToGist && this.gistCheckBox.isSelected()) {
                    data = Tools.createGist((String)this.fc.getSelectedFile().getName(), (String)MPFileUtils.readFile((String)this.fc.getSelectedFile().getPath()), (String)this.titlefield.getText());
                }
                postData.addProperty("crashLog", data);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            this.handleRecievedData(Tools.sendJsonHttpPost((String)MPBSettings.issuetrackerURL, (JsonObject)postData));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleRecievedData(String returnHttpPost) {
        Gson gson = new Gson();
        JsonObject jsonData = (JsonObject)gson.fromJson(returnHttpPost, JsonObject.class);
        String formatedReturn = "";
        if (jsonData.has("timestamp")) {
            long timestamp = jsonData.get("timestamp").getAsLong();
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, MMM d, ''yy", Locale.US);
            Date today = new Date();
            formatedReturn = "Recieved on " + formatter.format(today) + "\n\n";
        }
        if (jsonData.has("message")) {
            formatedReturn = formatedReturn + jsonData.get("message").getAsString() + "\n\n";
        }
        if (jsonData.has("gistLink")) {
            formatedReturn = formatedReturn + "Gist Link: " + jsonData.get("gistLink") + "\n\n";
        }
        this.resultTextArea.setText(formatedReturn);
    }

    public void createReport() {
        String title = this.titlefield.getText();
        String desc = this.descriptiontextArea.getText();
        String ign = Minecraft.func_71410_x().func_110432_I().func_111285_a();
        String forgeVersion = ForgeVersion.getVersion();
        String mcVersion = "1.12.2";
        String mpVersion = MPInfo.version;
        String os = System.getProperty("os.name");
        String java = this.list.get(0);
        String cpu = this.list.get(4);
        String gpu = this.list.get(7);
        String mem = this.list.get(1);
        String allocated = this.list.get(2);
        String modsLoaded = "" + Loader.instance().getActiveModList().size();
        String data = "No CrashLog";
        if (this.fc.getSelectedFile() != null && this.fc.getSelectedFile().exists()) {
            try {
                data = MPFileUtils.readFile((String)this.fc.getSelectedFile().getPath());
                if (MPBSettings.crashlogsToGist && this.gistCheckBox.isSelected()) {
                    data = Tools.createGist((String)this.fc.getSelectedFile().getName(), (String)MPFileUtils.readFile((String)this.fc.getSelectedFile().getPath()), (String)this.titlefield.getText());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String output = "=======Pack Info======= \n";
        output = output + "\n";
        output = output + "IGN: " + ign + "\n";
        output = output + "Pack Version: " + mpVersion + "\n";
        output = output + "MC Version: " + mcVersion + "\n";
        output = output + "Forge Version: " + forgeVersion + "\n";
        output = output + "Mods Loaded: " + modsLoaded + "\n";
        output = output + "\n";
        output = output + "=======System Info======= \n";
        output = output + "\n";
        output = output + "Operating System: " + os + "\n";
        output = output + "Java: " + java + "\n";
        output = output + "CPU: " + cpu + "\n";
        output = output + "Display: " + gpu + "\n";
        output = output + "Mem: " + mem + "\n";
        output = output + "Allocated: " + allocated + "\n";
        output = output + "\n";
        output = output + "======= Issue ======= \n \n";
        output = output + "Title: " + title + "\n \n";
        output = output + "--------------------------- \n";
        output = output + "Description: " + desc + "\n";
        output = output + "\n\n";
        output = output + "=======CrashLog======= \n";
        output = output + data + "\n";
        this.generatedReport.setText(output);
    }

    private static void goToHttp(String url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(url));
        }
        catch (Throwable throwable) {
            MPUtils.logger.error("Couldn't open link", throwable);
        }
    }
}

