/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.client.CreativeTab;

public class BlockRope
extends EnumBlock<RopeType> {
    public static final PropertyEnum<Rungs> RUNGS = PropertyEnum.func_177709_a((String)"rungs", Rungs.class);
    public static final PropertyEnum<RopeType> TYPE = PropertyEnum.func_177709_a((String)"type", RopeType.class);
    public static final PropertyBool BOTTOM = PropertyBool.func_177716_a((String)"bottom");
    protected static final AxisAlignedBB[] BOUNDS = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0625, 0.0, 0.375, 0.9375, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0625, 0.625, 1.0, 0.9375)};
    protected static final AxisAlignedBB[] BOUNDS_BOTTOM = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.25, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0625, 0.25, 0.375, 0.9375, 1.0, 0.625), new AxisAlignedBB(0.375, 0.25, 0.0625, 0.625, 1.0, 0.9375)};

    public BlockRope() {
        super(Material.field_151593_r, TYPE, RopeType.class);
        this.func_149647_a(CreativeTab.field_78031_c);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(TYPE, (Comparable)((Object)RopeType.ROPE)).func_177226_a(RUNGS, (Comparable)((Object)Rungs.NONE)));
        IBlockState chain = this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)RopeType.CHAIN));
        for (Rungs rungs : Rungs.values()) {
            this.setHarvestLevel("pickaxe", 0, chain.func_177226_a(RUNGS, (Comparable)((Object)rungs)));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, RUNGS, BOTTOM});
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        return state.func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(!this.canConnectTo(world.func_180495_p(down), world, down, EnumFacing.UP)));
    }

    private boolean canConnectTo(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (state.func_177230_c() == this) {
            return true;
        }
        BlockFaceShape shape = state.func_193401_d(world, pos, side);
        return shape == BlockFaceShape.CENTER || shape == BlockFaceShape.CENTER_BIG || shape == BlockFaceShape.SOLID;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.prop, (Comparable)((Object)this.fromMeta(meta & 3))).func_177226_a(RUNGS, (Comparable)((Object)Rungs.fromMeta(meta >> 2)));
    }

    public int func_176201_c(IBlockState state) {
        return ((RopeType)((Object)state.func_177229_b((IProperty)this.prop))).getMeta() | ((Rungs)((Object)state.func_177229_b(RUNGS))).getMeta() << 2;
    }

    public int func_180651_a(IBlockState state) {
        return ((RopeType)((Object)state.func_177229_b((IProperty)this.prop))).getMeta();
    }

    @Deprecated
    public Material func_149688_o(IBlockState state) {
        if (state.func_177229_b(TYPE) == RopeType.CHAIN) {
            return Material.field_151573_f;
        }
        return super.func_149688_o(state);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        switch ((RopeType)((Object)state.func_177229_b(TYPE))) {
            case ROPE: {
                return SoundType.field_185854_g;
            }
            case CHAIN: {
                return SoundType.field_185852_e;
            }
            case VINE: {
                return SoundType.field_185850_c;
            }
        }
        return super.getSoundType(state, world, pos, entity);
    }

    @Deprecated
    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        if (state.func_177229_b(TYPE) == RopeType.CHAIN) {
            return 5.0f;
        }
        return super.func_176195_g(state, worldIn, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (world.func_180495_p(pos).func_177229_b(TYPE) == RopeType.CHAIN) {
            return 30.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.isValidRope(world, pos);
    }

    private boolean isValidRope(World world, BlockPos pos) {
        BlockPos up = pos.func_177984_a();
        IBlockState state = world.func_180495_p(up);
        return this.canConnectTo(state, (IBlockAccess)world, pos, EnumFacing.DOWN);
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.isValidRope(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
        super.func_189540_a(state, world, pos, blockIn, fromPos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float clickX, float clickY, float clickZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (Block.func_149634_a((Item)stack.func_77973_b()) == this) {
            return this.extendRope(world, pos, state, side, player, stack, clickX, clickY, clickZ);
        }
        return false;
    }

    private boolean extendRope(World world, BlockPos pos, IBlockState state, EnumFacing side, EntityPlayer player, ItemStack stack, float clickX, float clickY, float clickZ) {
        IBlockState newState;
        ItemBlock itemBlock;
        RopeType type = (RopeType)((Object)state.func_177229_b(TYPE));
        if (stack.func_77960_j() != type.getMeta()) {
            return false;
        }
        BlockPos next = pos.func_177977_b();
        IBlockState below = world.func_180495_p(next);
        while (below.func_177230_c() == this && below.func_177229_b(TYPE) == type) {
            next = next.func_177977_b();
            below = world.func_180495_p(next);
        }
        if (this.func_176196_c(world, next) && (itemBlock = (ItemBlock)stack.func_77973_b()).placeBlockAt(stack, player, world, next, side, clickX, clickY, clickZ, newState = this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type)))) {
            SoundType soundtype = newState.func_177230_c().getSoundType(newState, world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        return true;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        if (state.func_177229_b(RUNGS) != Rungs.NONE) {
            drops.add((Object)new ItemStack(((RopeType)((Object)state.func_177229_b(TYPE))).getItem(), 4));
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        RopeType type = (RopeType)((Object)state.func_177229_b(TYPE));
        BlockPos next = pos.func_177977_b();
        IBlockState below = world.func_180495_p(next);
        int count = 0;
        int extra = 0;
        while (below.func_177230_c() == this && below.func_177229_b(TYPE) == type) {
            ++count;
            if (below.func_177229_b(RUNGS) != Rungs.NONE) {
                ++extra;
            }
            next = next.func_177977_b();
            below = world.func_180495_p(next);
        }
        for (int i = 0; i < count; ++i) {
            next = next.func_177984_a();
            world.func_175655_b(next, false);
        }
        ItemStack drops = new ItemStack((Block)this, count, type.getMeta());
        BlockRope.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drops);
        if (extra > 0) {
            ItemStack extraDrop = new ItemStack(type.getItem(), extra * 4);
            BlockRope.func_180635_a((World)world, (BlockPos)pos, (ItemStack)extraDrop);
        }
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Deprecated
    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int rungs = ((Rungs)((Object)state.func_177229_b(RUNGS))).getMeta();
        if (((Boolean)state.func_185899_b(source, pos).func_177229_b((IProperty)BOTTOM)).booleanValue()) {
            return BOUNDS_BOTTOM[rungs];
        }
        return BOUNDS[rungs];
    }

    public static enum Rungs implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        NONE,
        X,
        Z;

        private int meta = this.ordinal();

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }

        public static Rungs fromMeta(int meta) {
            if (meta < 0 || meta > Rungs.values().length) {
                return NONE;
            }
            return Rungs.values()[meta];
        }

        public static Rungs fromAxis(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return X;
                }
                case Z: {
                    return Z;
                }
            }
            return NONE;
        }
    }

    public static enum RopeType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        ROPE,
        CHAIN,
        VINE;

        private int meta = this.ordinal();

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }

        public Item getItem() {
            if (this == CHAIN) {
                return Items.field_191525_da;
            }
            return Items.field_151055_y;
        }
    }
}

