/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron;

import javax.annotation.ParametersAreNonnullByDefault;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.recipe.cauldron.CauldronFluidRecipe;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import slimeknights.mantle.util.RecipeMatch;

@ParametersAreNonnullByDefault
public class FillCauldronRecipe
extends CauldronFluidRecipe {
    private int amount;

    public FillCauldronRecipe(RecipeMatch input, Fluid fluid, int amount, ItemStack container, Boolean boiling, SoundEvent sound) {
        super(input, fluid, container, boiling, 0, sound);
        this.amount = amount;
    }

    public FillCauldronRecipe(RecipeMatch input, Fluid fluid, int amount, ItemStack container, SoundEvent sound) {
        this(input, fluid, amount, container, null, sound);
    }

    public FillCauldronRecipe(RecipeMatch input, Fluid fluid, int amount, ItemStack container) {
        this(input, fluid, amount, container, SoundEvents.field_191241_J);
    }

    public FillCauldronRecipe(RecipeMatch input, Fluid fluid, int amount) {
        this(input, fluid, amount, ItemStack.field_190927_a);
    }

    @Override
    public boolean matches(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        if (level == InspirationsRegistry.getCauldronMax() || level > 0 && !state.matches(this.fluid) || this.boiling != null && boiling != this.boiling) {
            return false;
        }
        return this.matches(stack);
    }

    @Override
    public ICauldronRecipe.CauldronState getState(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return this.fluid;
    }

    @Override
    public int getLevel(int level) {
        return level + this.amount;
    }

    @Override
    public int getInputLevel() {
        return 0;
    }

    @Override
    public ItemStack getContainer(ItemStack stack) {
        return ItemStack.field_190927_a;
    }

    @Override
    public String toString() {
        return String.format("FillCauldronRecipe: filling with %s", this.fluid.getFluid().getName());
    }
}

