/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins.jei.cauldron;

import java.util.ArrayList;
import java.util.List;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.ISimpleCauldronRecipe;
import knightminer.inspirations.plugins.jei.cauldron.CauldronRecipeWrapper;
import knightminer.inspirations.plugins.jei.cauldron.DyeFillWrapper;
import knightminer.inspirations.plugins.jei.cauldron.ICauldronRecipeWrapper;
import knightminer.inspirations.plugins.jei.cauldron.PotionWrapper;
import knightminer.inspirations.shared.InspirationsShared;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.BannerPattern;

public class CauldronRecipeChecker {
    public static List<ICauldronRecipeWrapper> getRecipes() {
        ArrayList<ICauldronRecipeWrapper> recipes = new ArrayList<ICauldronRecipeWrapper>();
        recipes.add(CauldronRecipeChecker.makeArmorWashRecipe(Items.field_151024_Q));
        recipes.add(CauldronRecipeChecker.makeArmorWashRecipe(Items.field_151027_R));
        recipes.add(CauldronRecipeChecker.makeArmorWashRecipe(Items.field_151026_S));
        recipes.add(CauldronRecipeChecker.makeArmorWashRecipe(Items.field_151021_T));
        CauldronRecipeChecker.makeBannerRecipes(recipes);
        for (ICauldronRecipe recipe : InspirationsRegistry.getAllCauldronRecipes()) {
            ISimpleCauldronRecipe simpleRecipe;
            if (!(recipe instanceof ISimpleCauldronRecipe) || (simpleRecipe = (ISimpleCauldronRecipe)recipe).getState() == null || simpleRecipe.getInputState() == null || !CauldronRecipeChecker.inputValid(simpleRecipe.getInput())) continue;
            recipes.add(new CauldronRecipeWrapper(simpleRecipe));
        }
        if (Config.enableCauldronDyeing) {
            recipes.add(new DyeFillWrapper(true));
            recipes.add(new DyeFillWrapper(false));
        }
        if (Config.enableCauldronPotions) {
            CauldronRecipeChecker.makePotionFillRecipes(recipes, (Item)Items.field_151068_bn, new ItemStack(Items.field_151069_bo), null);
            CauldronRecipeChecker.makePotionFillRecipes(recipes, (Item)Items.field_185155_bH, InspirationsShared.splashBottle, "bottleSplash");
            CauldronRecipeChecker.makePotionFillRecipes(recipes, (Item)Items.field_185156_bI, InspirationsShared.lingeringBottle, "bottleLingering");
            recipes.add(new PotionWrapper.Fill(new ItemStack(Items.field_185167_i, 8), new ItemStack(Items.field_151032_g, 8)));
        }
        return recipes;
    }

    private static boolean inputValid(List<ItemStack> input) {
        if (input == null || input.isEmpty()) {
            return false;
        }
        return !input.stream().anyMatch(s -> ItemStack.func_179545_c((ItemStack)s, (ItemStack)InspirationsShared.mushrooms) || ItemStack.func_179545_c((ItemStack)s, (ItemStack)InspirationsShared.rabbitStewMix));
    }

    private static CauldronRecipeWrapper makeArmorWashRecipe(ItemArmor item) {
        ItemStack output = new ItemStack((Item)item);
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ItemStack stack = output.func_77946_l();
            item.func_82813_b(stack, color.func_193350_e());
            input.add(stack);
        }
        return new CauldronRecipeWrapper(input, output);
    }

    private static void makeBannerRecipes(List<ICauldronRecipeWrapper> recipes) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            EnumDyeColor patternColor = color == EnumDyeColor.WHITE ? EnumDyeColor.GRAY : EnumDyeColor.WHITE;
            ItemStack output = new ItemStack(Items.field_179564_cE, 1, color.func_176767_b());
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            for (BannerPattern pattern : BannerPattern.values()) {
                if (pattern == BannerPattern.BASE) continue;
                ItemStack stack = output.func_77946_l();
                NBTTagCompound entityTag = stack.func_190925_c("BlockEntityTag");
                NBTTagList patternList = new NBTTagList();
                entityTag.func_74782_a("Patterns", (NBTBase)patternList);
                NBTTagCompound patternTag = new NBTTagCompound();
                patternTag.func_74778_a("Pattern", pattern.func_190993_b());
                patternTag.func_74768_a("Color", patternColor.func_176767_b());
                patternList.func_74742_a((NBTBase)patternTag);
                inputs.add(stack);
            }
            recipes.add(new CauldronRecipeWrapper(inputs, output));
        }
    }

    public static void makePotionFillRecipes(List<ICauldronRecipeWrapper> recipes, Item potionItem, ItemStack bottle, String bottleOre) {
        ItemStack potion = new ItemStack(potionItem);
        if (bottleOre != null) {
            recipes.add(new PotionWrapper.Fill(potion, bottleOre));
        } else {
            recipes.add(new PotionWrapper.Fill(potion, bottle));
        }
        recipes.add(new PotionWrapper.Empty(potion, bottle));
    }
}

