/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.ISimpleCauldronRecipe;
import knightminer.inspirations.recipes.InspirationsRecipes;
import knightminer.inspirations.shared.InspirationsOredict;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.oredict.OreIngredient;

public class DyeCauldronWater
implements ISimpleCauldronRecipe {
    private EnumDyeColor color;
    private Ingredient dye;

    public DyeCauldronWater(EnumDyeColor color) {
        this.color = color;
        this.dye = new OreIngredient(InspirationsOredict.dyeNameFor(color));
    }

    @Override
    public boolean matches(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        if (level == 0 || stack.func_77973_b() == InspirationsRecipes.dyedWaterBottle) {
            return false;
        }
        return (state.isWater() || state.getColor() > -1) && this.dye.apply(stack) && this.color.field_193351_w != state.getColor();
    }

    @Override
    public List<ItemStack> getInput() {
        return Arrays.stream(this.dye.func_193365_a()).filter(stack -> stack.func_77973_b() != InspirationsRecipes.dyedWaterBottle).collect(Collectors.toList());
    }

    @Override
    public ICauldronRecipe.CauldronState getState(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        int newColor = this.color.field_193351_w;
        int color = state.getColor();
        color = color > -1 ? Util.combineColors(newColor, color, level) : newColor;
        return ICauldronRecipe.CauldronState.dye(color);
    }

    @Override
    public Object getState() {
        return this.color;
    }

    @Override
    public SoundEvent getSound(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return null;
    }
}

