/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.shared.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import knightminer.inspirations.library.util.TagUtil;
import knightminer.inspirations.library.util.TextureBlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import slimeknights.mantle.client.ModelHelper;

public class TextureModel
extends BakedModelWrapper<IBakedModel> {
    private final Map<String, IBakedModel> cache = new HashMap<String, IBakedModel>();
    private IModel model;
    private final VertexFormat format;
    private final String textureKey;
    private boolean item;

    public TextureModel(IBakedModel originalModel, IModel model, VertexFormat format, String textureKey, boolean item) {
        super(originalModel);
        this.model = model;
        this.format = format;
        this.textureKey = textureKey;
        this.item = item;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        IExtendedBlockState extendedState;
        String texture;
        IBakedModel bakedModel = this.originalModel;
        if (state instanceof IExtendedBlockState && (texture = (String)(extendedState = (IExtendedBlockState)state).getValue((IUnlistedProperty)TextureBlockUtil.TEXTURE_PROP)) != null) {
            bakedModel = this.getCachedTextureModel(texture);
        }
        return bakedModel.func_188616_a(state, side, rand);
    }

    protected IBakedModel getTexturedModel(ImmutableMap<String, String> textures) {
        IModel retextured = this.model.retexture(textures);
        return retextured.bake(retextured.getDefaultState(), this.format, ModelLoader.defaultTextureGetter());
    }

    protected IBakedModel getCachedTextureModel(String texture) {
        return this.cache.computeIfAbsent(texture, tex -> this.getTexturedModel((ImmutableMap<String, String>)ImmutableMap.of((Object)this.textureKey, (Object)tex)));
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.item ? ItemTextureOverride.INSTANCE : super.func_188617_f();
    }

    private static class ItemTextureOverride
    extends ItemOverrideList {
        static ItemTextureOverride INSTANCE = new ItemTextureOverride();

        private ItemTextureOverride() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            ItemStack blockStack;
            if (originalModel instanceof TextureModel && !(blockStack = new ItemStack(TagUtil.getTagSafe(stack).func_74775_l("texture"))).func_190926_b()) {
                Item item = blockStack.func_77973_b();
                Block block = Block.func_149634_a((Item)item);
                String texture = ModelHelper.getTextureFromBlock((Block)block, (int)item.getMetadata(blockStack)).func_94215_i();
                TextureModel textureModel = (TextureModel)originalModel;
                return textureModel.getCachedTextureModel(texture);
            }
            return originalModel;
        }
    }
}

