/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import knightminer.inspirations.common.ClientProxy;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.client.IgnoreAllStateMapper;
import knightminer.inspirations.library.client.NameStateMapper;
import knightminer.inspirations.library.client.PropertyStateMapper;
import knightminer.inspirations.utility.InspirationsUtility;
import knightminer.inspirations.utility.block.BlockBricksButton;
import knightminer.inspirations.utility.block.BlockCollector;
import knightminer.inspirations.utility.block.BlockRedstoneBarrel;
import knightminer.inspirations.utility.block.BlockTorchLever;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class UtilityClientProxy
extends ClientProxy {
    private static final ResourceLocation CARPETED_TRAPDOOR = Util.getResource("carpeted_trapdoor");

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        UtilityClientProxy.setModelStateMapper(InspirationsUtility.torchLever, (IStateMapper)new TorchLeverStateMapper());
        UtilityClientProxy.setModelStateMapper(InspirationsUtility.redstoneTorchLever, (IStateMapper)new RedstoneTorchLeverStateMapper(false));
        UtilityClientProxy.setModelStateMapper(InspirationsUtility.redstoneTorchLeverPowered, (IStateMapper)new RedstoneTorchLeverStateMapper(true));
        UtilityClientProxy.setModelStateMapper((Block)InspirationsUtility.bricksButton, (IStateMapper)new PropertyStateMapper(BlockBricksButton.TYPE, new IProperty[0]));
        NameStateMapper carpetedPressurePlate = new NameStateMapper(Util.getResource("carpeted_pressure_plate"), new IProperty[0]);
        UtilityClientProxy.setModelStateMapper(InspirationsUtility.carpetedPressurePlate1, (IStateMapper)carpetedPressurePlate);
        UtilityClientProxy.setModelStateMapper(InspirationsUtility.carpetedPressurePlate2, (IStateMapper)carpetedPressurePlate);
        UtilityClientProxy.setModelStateMapper(InspirationsUtility.collector, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockCollector.TRIGGERED}).func_178441_a());
        UtilityClientProxy.setModelStateMapper(InspirationsUtility.pipe, (IStateMapper)IgnoreAllStateMapper.INSTANCE);
        UtilityClientProxy.registerItemModel(InspirationsUtility.torchLever);
        UtilityClientProxy.registerItemModel(InspirationsUtility.redstoneTorchLever);
        UtilityClientProxy.registerItemModel(InspirationsUtility.redstoneBarrel);
        UtilityClientProxy.registerItemModel(InspirationsUtility.collector);
        UtilityClientProxy.registerItemModel(InspirationsUtility.pipe);
        UtilityClientProxy.registerItemModel((Block)InspirationsUtility.bricksButton, 0, Util.getResource("bricks_button/bricks"));
        UtilityClientProxy.registerItemModel((Block)InspirationsUtility.bricksButton, 1, Util.getResource("bricks_button/nether"));
        this.registerCarpetedTrapdoorModels(InspirationsUtility.carpetedTrapdoors);
    }

    private void registerCarpetedTrapdoorModels(Block[] blocks) {
        if (blocks != null) {
            for (int i = 0; i < blocks.length; ++i) {
                EnumDyeColor color = EnumDyeColor.func_176764_b((int)i);
                UtilityClientProxy.registerItemModel(blocks[i], 0, CARPETED_TRAPDOOR, String.format("color=%s,facing=north,shape=bottom", color.func_176610_l()));
                UtilityClientProxy.setModelStateMapper(blocks[i], (IStateMapper)new CarpetedTrapdoorStateMapper(color));
            }
        }
    }

    @SubscribeEvent
    public void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        UtilityClientProxy.registerBlockColors(blockColors, (state, world, pos, tintIndex) -> {
            int level;
            if (tintIndex == 1 && (level = ((Integer)state.func_177229_b((IProperty)BlockRedstoneBarrel.LEVEL)).intValue()) > 0) {
                return BlockRedstoneWire.func_176337_b((int)level);
            }
            return -1;
        }, InspirationsUtility.redstoneBarrel);
    }

    private static class CarpetedTrapdoorStateMapper
    extends StateMapperBase {
        private static final PropertyEnum<TrapdoorShape> SHAPE = PropertyEnum.func_177709_a((String)"shape", TrapdoorShape.class);
        private EnumDyeColor color;

        public CarpetedTrapdoorStateMapper(EnumDyeColor color) {
            this.color = color;
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            boolean bottom;
            LinkedHashMap map = Maps.newLinkedHashMap();
            map.put(BlockColored.field_176581_a, this.color);
            map.put(BlockTrapDoor.field_176284_a, state.func_177229_b((IProperty)BlockTrapDoor.field_176284_a));
            TrapdoorShape shape = null;
            boolean open = (Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b);
            boolean bl = bottom = state.func_177229_b((IProperty)BlockTrapDoor.field_176285_M) == BlockTrapDoor.DoorHalf.BOTTOM;
            shape = bottom ? (open ? TrapdoorShape.BOTTOM_OPEN : TrapdoorShape.BOTTOM) : (open ? TrapdoorShape.TOP_OPEN : TrapdoorShape.TOP);
            map.put(SHAPE, shape);
            return new ModelResourceLocation(CARPETED_TRAPDOOR, this.func_178131_a(map));
        }

        private static enum TrapdoorShape implements IStringSerializable
        {
            BOTTOM,
            BOTTOM_OPEN,
            TOP,
            TOP_OPEN;


            public String func_176610_l() {
                return this.name().toLowerCase(Locale.US);
            }
        }
    }

    private static class RedstoneTorchLeverStateMapper
    extends StateMapperBase {
        private boolean powered;

        public RedstoneTorchLeverStateMapper(boolean powered) {
            this.powered = powered;
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            ResourceLocation res = InspirationsUtility.redstoneTorchLever.getRegistryName();
            LinkedHashMap map = Maps.newLinkedHashMap((Map)state.func_177228_b());
            map.put(BlockLever.field_176359_b, this.powered);
            return new ModelResourceLocation(res, this.func_178131_a(map));
        }
    }

    private static class TorchLeverStateMapper
    extends StateMapperBase {
        private TorchLeverStateMapper() {
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            ResourceLocation base = state.func_177230_c().getRegistryName();
            LinkedHashMap map = Maps.newLinkedHashMap((Map)state.func_177228_b());
            String suffix = "";
            if (state.func_177229_b((IProperty)BlockTorchLever.field_176596_a) == EnumFacing.UP) {
                map.remove(BlockTorchLever.field_176596_a);
            } else {
                map.remove(BlockTorchLever.SIDE);
                suffix = "_wall";
            }
            ResourceLocation res = new ResourceLocation(base.func_110624_b(), base.func_110623_a() + suffix);
            return new ModelResourceLocation(res, this.func_178131_a(map));
        }
    }
}

