/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.tileentity;

import javax.annotation.Nonnull;
import knightminer.inspirations.utility.client.GuiCollector;
import knightminer.inspirations.utility.inventory.ContainerCollector;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.mantle.tileentity.TileInventory;

public class TileCollector
extends TileInventory
implements IInventoryGui {
    public TileCollector() {
        super("gui.inspirations.collector.name", 9);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void collect(EnumFacing facing) {
        IItemHandler neighbor;
        BlockPos offset = this.field_174879_c.func_177972_a(facing);
        TileEntity te = this.field_145850_b.func_175625_s(offset);
        if (te != null && (neighbor = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) != null) {
            for (int i = 0; i < neighbor.getSlots(); ++i) {
                ItemStack simulated = neighbor.extractItem(i, 1, true);
                if (simulated.func_190926_b() || !ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)simulated, (boolean)false).func_190926_b()) continue;
                neighbor.extractItem(i, 1, false);
                break;
            }
            return;
        }
        AxisAlignedBB aabb = new AxisAlignedBB((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p(), (double)(offset.func_177958_n() + 1), (double)(offset.func_177956_o() + 1), (double)(offset.func_177952_p() + 1));
        boolean collected = false;
        for (EntityItem entity : this.field_145850_b.func_72872_a(EntityItem.class, aabb)) {
            ItemStack insert = entity.func_92059_d();
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)insert, (boolean)false);
            if (remainder.func_190916_E() >= insert.func_190916_E()) continue;
            collected = true;
            if (remainder.func_190926_b()) {
                entity.func_70106_y();
                continue;
            }
            entity.func_92058_a(remainder);
        }
        this.field_145850_b.func_175718_b(collected ? 1000 : 1001, this.field_174879_c, 0);
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack itemstack) {
        return slot < this.func_70302_i_();
    }

    public ContainerCollector createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerCollector(inventoryplayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiCollector(this.createContainer(inventoryplayer, world, pos));
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.getTileData().func_74737_b();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }
}

