/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.apiimpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.api.IStorageNetworkPlugin;
import mrriegel.storagenetwork.api.StorageNetworkPlugin;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class AnnotatedInstanceUtil {
    public static ASMDataTable asmDataTable;

    private AnnotatedInstanceUtil() {
    }

    public static List<IStorageNetworkPlugin> getPlugins() {
        return AnnotatedInstanceUtil.getInstances(StorageNetworkPlugin.class, IStorageNetworkPlugin.class);
    }

    private static <T> Map<Class<? extends T>, Map<String, Object>> getClassesWithAnnotations(Class annotationClass, Class<T> instanceClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        HashMap<Class<T>, Map<String, Object>> classes = new HashMap<Class<T>, Map<String, Object>>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                String requiredMod;
                Map annotationInfo = asmData.getAnnotationInfo();
                if (annotationInfo.containsKey("mod") && (requiredMod = (String)annotationInfo.get("mod")).length() > 0 && !Loader.isModLoaded((String)requiredMod)) continue;
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                classes.put(asmInstanceClass, annotationInfo);
            }
            catch (ClassNotFoundException | ExceptionInInitializerError e) {
                StorageNetwork.instance.logger.error("Failed to load: {}", (Object)asmData.getClassName(), (Object)e);
            }
        }
        return classes;
    }

    private static <T> List<Class<? extends T>> getClasses(Class annotationClass, Class<T> instanceClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                String requiredMod;
                Map annotationInfo = asmData.getAnnotationInfo();
                if (annotationInfo.containsKey("mod") && (requiredMod = (String)annotationInfo.get("mod")).length() > 0 && !Loader.isModLoaded((String)requiredMod)) continue;
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                classes.add(asmInstanceClass);
            }
            catch (ClassNotFoundException | ExceptionInInitializerError e) {
                StorageNetwork.instance.logger.error("Failed to load: {}", (Object)asmData.getClassName(), (Object)e);
            }
        }
        return classes;
    }

    private static <T> Map<T, Map<String, Object>> getInstancesWithAnnotations(Class annotationClass, Class<T> instanceClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        HashMap<T, Map> instances = new HashMap<T, Map>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                String requiredMod;
                Map annotationInfo = asmData.getAnnotationInfo();
                if (annotationInfo.containsKey("mod") && (requiredMod = (String)annotationInfo.get("mod")).length() > 0 && !Loader.isModLoaded((String)requiredMod)) continue;
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.put(instance, annotationInfo);
            }
            catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | InstantiationException e) {
                StorageNetwork.instance.logger.error("Failed to load: {}", (Object)asmData.getClassName(), (Object)e);
            }
        }
        return instances;
    }

    private static <T> List<T> getInstances(Class annotationClass, Class<T> instanceClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                String requiredMod;
                Map annotationInfo = asmData.getAnnotationInfo();
                if (annotationInfo.containsKey("mod") && (requiredMod = (String)annotationInfo.get("mod")).length() > 0 && !Loader.isModLoaded((String)requiredMod)) continue;
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | InstantiationException e) {
                StorageNetwork.instance.logger.error("Failed to load: {}", (Object)asmData.getClassName(), (Object)e);
            }
        }
        return instances;
    }
}

