/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block;

import javax.annotation.Nullable;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.api.data.DimPos;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.capabilities.CapabilityConnectable;
import mrriegel.storagenetwork.capabilities.StorageNetworkCapabilities;
import mrriegel.storagenetwork.config.ConfigHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileConnectable
extends TileEntity {
    private World worldCreate;
    protected CapabilityConnectable connectable = new CapabilityConnectable();

    public DimPos getDimPos() {
        return new DimPos(this.field_145850_b == null ? this.worldCreate : this.field_145850_b, this.field_174879_c);
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        this.connectable.setPos(this.getDimPos());
    }

    protected void func_190201_b(World worldIn) {
        super.func_190201_b(worldIn);
        this.worldCreate = worldIn;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("connectable")) {
            this.connectable.deserializeNBT(compound.func_74775_l("connectable"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound result = super.func_189515_b(compound);
        result.func_74782_a("connectable", (NBTBase)this.connectable.serializeNBT());
        return result;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.func_189515_b(syncData);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void onChunkUnload() {
        if (ConfigHandler.reloadNetworkWhenUnloadChunk && this.connectable != null && this.connectable.getMasterPos() != null) {
            try {
                TileMaster maybeMaster = StorageNetwork.helpers.getTileMasterForConnectable(this.connectable);
                if (maybeMaster != null) {
                    maybeMaster.refreshNetwork();
                }
            }
            catch (Exception e) {
                StorageNetwork.instance.logger.error("Error on chunk unload ", (Throwable)e);
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == StorageNetworkCapabilities.CONNECTABLE_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == StorageNetworkCapabilities.CONNECTABLE_CAPABILITY) {
            return (T)this.connectable;
        }
        return (T)super.getCapability(capability, facing);
    }

    public DimPos getMaster() {
        return this.connectable.getMasterPos();
    }
}

