/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.cable.io;

import com.google.common.collect.Lists;
import java.io.IOException;
import mrriegel.storagenetwork.api.data.EnumUpgradeType;
import mrriegel.storagenetwork.block.cable.GuiCable;
import mrriegel.storagenetwork.block.cable.GuiCableButton;
import mrriegel.storagenetwork.block.cable.io.ContainerCableIO;
import mrriegel.storagenetwork.gui.ItemSlotNetwork;
import mrriegel.storagenetwork.network.CableDataMessage;
import mrriegel.storagenetwork.network.CableLimitMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import mrriegel.storagenetwork.util.inventory.FilterItemStackHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;

public class GuiCableIO
extends GuiCable {
    ContainerCableIO containerCableIO;
    protected GuiCableButton btnOperationToggle;
    protected ItemSlotNetwork operationItemSlot;
    protected GuiTextField fieldOperationLimit;

    public GuiCableIO(ContainerCableIO containerCableIO) {
        super(containerCableIO);
        this.containerCableIO = containerCableIO;
    }

    @Override
    public FilterItemStackHandler getFilterHandler() {
        return this.containerCableIO.cap.filters;
    }

    @Override
    public void importSlotsButtonPressed() {
        super.importSlotsButtonPressed();
        int targetSlot = 0;
        for (ItemStack filterSuggestion : this.containerCableIO.cap.getStacksForFilter()) {
            if (this.containerCableIO.cap.filters.isStackFiltered(filterSuggestion)) continue;
            this.containerCableIO.cap.filters.setStackInSlot(targetSlot, filterSuggestion.func_77946_l());
            if (++targetSlot < this.containerCableIO.cap.filters.getSlots()) continue;
            break;
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.btnWhite.setCustomDrawMethod(guiCableButton -> {
            if (this.containerCableIO.cap.filters.isWhitelist) {
                this.func_73729_b(guiCableButton.field_146128_h + 1, guiCableButton.field_146129_i + 3, 176, 83, 13, 10);
            } else {
                this.func_73729_b(guiCableButton.field_146128_h + 1, guiCableButton.field_146129_i + 3, 190, 83, 13, 10);
            }
        });
        Keyboard.enableRepeatEvents((boolean)true);
        this.fieldOperationLimit = new GuiTextField(99, this.field_146289_q, this.field_147003_i + 54, this.field_147009_r + 69, 26, this.field_146289_q.field_78288_b);
        this.fieldOperationLimit.func_146203_f(3);
        this.fieldOperationLimit.func_146185_a(false);
        this.fieldOperationLimit.func_146189_e(true);
        this.fieldOperationLimit.func_146193_g(0xFFFFFF);
        this.fieldOperationLimit.func_146205_d(false);
        this.fieldOperationLimit.func_146195_b(true);
        this.fieldOperationLimit.func_146180_a("" + this.containerCableIO.cap.operationLimit);
        this.fieldOperationLimit.field_146218_h = 20;
        this.btnOperationToggle = new GuiCableButton(CableDataMessage.CableMessageType.TOGGLE_MODE, this.field_147003_i + 28, this.field_147009_r + 66, "");
        this.btnOperationToggle.setCustomDrawMethod(guiCableButton -> {
            guiCableButton.field_146126_j = this.containerCableIO.cap.operationMustBeSmaller ? "<" : ">";
        });
        this.func_189646_b(this.btnOperationToggle);
        this.operationItemSlot = new ItemSlotNetwork(this, this.containerCableIO.cap.operationStack, this.field_147003_i + 8, this.field_147009_r + 66, 1, this.field_147003_i, this.field_147009_r, false);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int xMiddle = (this.field_146294_l - this.field_146999_f) / 2;
        int yMiddle = (this.field_146295_m - this.field_147000_g) / 2;
        int u = 176;
        int v = 34;
        for (int ug = 0; ug < EnumUpgradeType.values().length; ++ug) {
            this.func_73729_b(xMiddle + 97 + ug * 18, yMiddle + 5, u, v, 18, 18);
        }
        if (this.containerCableIO == null || this.containerCableIO.cap == null) {
            return;
        }
        if (this.hasOperationUpgrade(EnumUpgradeType.OPERATION)) {
            this.btnOperationToggle.field_146124_l = true;
            this.btnOperationToggle.field_146125_m = true;
            this.field_146297_k.func_110434_K().func_110577_a(this.texture);
            this.func_73729_b(xMiddle + 7, yMiddle + 65, u, v, 18, 18);
            this.func_73729_b(xMiddle + 50, yMiddle + 67, 0, 171, 26, 12);
            this.fieldOperationLimit.func_146194_f();
            this.operationItemSlot.drawSlot(mouseX, mouseY);
        } else if (this.btnOperationToggle != null) {
            this.btnOperationToggle.field_146124_l = false;
            this.btnOperationToggle.field_146125_m = false;
        }
        this.checkOreBtn.setIsChecked(this.containerCableIO.cap.filters.ores);
        this.checkMetaBtn.setIsChecked(this.containerCableIO.cap.filters.meta);
        this.checkNbtBtn.setIsChecked(this.containerCableIO.cap.filters.nbt);
        this.field_146289_q.func_78276_b(String.valueOf(this.containerCableIO.cap.getPriority()), this.field_147003_i + 30 - this.field_146289_q.func_78256_a(String.valueOf(this.containerCableIO.cap.getPriority())) / 2, 5 + this.btnMinus.field_146129_i, 0x404040);
        this.itemSlotsGhost = Lists.newArrayList();
        int rows = 2;
        int cols = 9;
        int index = 0;
        int y = 26;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                ItemStack stack = this.containerCableIO.cap.filters.getStackInSlot(index);
                int x = 8 + col * 18;
                this.itemSlotsGhost.add(new ItemSlotNetwork(this, stack, this.field_147003_i + x, this.field_147009_r + y, stack.func_190916_E(), this.field_147003_i, this.field_147009_r, true));
                ++index;
            }
            y += 18;
        }
        for (ItemSlotNetwork s : this.itemSlotsGhost) {
            s.setShowNumbers(this.hasOperationUpgrade(EnumUpgradeType.STOCK));
            s.drawSlot(mouseX, mouseY);
        }
    }

    @Override
    protected void drawTooltips(int mouseX, int mouseY) {
        super.drawTooltips(mouseX, mouseY);
        if (this.containerCableIO == null || this.containerCableIO.cap == null) {
            return;
        }
        if (this.hasOperationUpgrade(EnumUpgradeType.OPERATION)) {
            this.operationItemSlot.drawTooltip(mouseX, mouseY);
            if (this.btnOperationToggle.func_146115_a()) {
                String s = I18n.func_135052_a((String)"gui.storagenetwork.operate.tooltip", (Object[])new Object[]{I18n.func_135052_a((String)("gui.storagenetwork.operate.tooltip." + (this.containerCableIO.cap.operationMustBeSmaller ? "less" : "more")), (Object[])new Object[0]), this.containerCableIO.cap.operationLimit, this.containerCableIO.cap.operationStack != null ? this.containerCableIO.cap.operationStack.func_82833_r() : "Items"});
                this.drawHoveringText(Lists.newArrayList((Object[])new String[]{s}), mouseX, mouseY, this.field_146289_q);
            }
        }
    }

    private boolean hasOperationUpgrade(EnumUpgradeType u) {
        return this.containerCableIO.cap.upgrades.getUpgradesOfType(u) > 0;
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (this.containerCableIO == null || this.containerCableIO.cap == null) {
            return;
        }
        if (button.field_146127_k == this.btnMinus.field_146127_k) {
            --this.containerCableIO.cap.priority;
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableDataMessage(button.field_146127_k));
        } else if (button.field_146127_k == this.btnPlus.field_146127_k) {
            ++this.containerCableIO.cap.priority;
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableDataMessage(button.field_146127_k));
        } else if (button.field_146127_k == this.btnOperationToggle.field_146127_k) {
            this.containerCableIO.cap.operationMustBeSmaller = !this.containerCableIO.cap.operationMustBeSmaller;
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableDataMessage(button.field_146127_k));
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        ItemStack stackCarriedByMouse = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_77946_l();
        if (this.containerCableIO.cap.upgrades.getUpgradesOfType(EnumUpgradeType.OPERATION) < 1) {
            return;
        }
        if (!this.operationItemSlot.isMouseOverSlot(mouseX, mouseY)) {
            return;
        }
        this.operationItemSlot.setStack(stackCarriedByMouse);
        int num = this.fieldOperationLimit.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.fieldOperationLimit.func_146179_b());
        PacketRegistry.INSTANCE.sendToServer((IMessage)new CableLimitMessage(num, stackCarriedByMouse));
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (!this.func_146983_a(keyCode)) {
            Keyboard.enableRepeatEvents((boolean)true);
            String s = "";
            if (this.hasOperationUpgrade(EnumUpgradeType.OPERATION)) {
                s = this.fieldOperationLimit.func_146179_b();
            }
            if (this.hasOperationUpgrade(EnumUpgradeType.OPERATION) && this.fieldOperationLimit.func_146201_a(typedChar, keyCode)) {
                if (!StringUtils.isNumeric((CharSequence)this.fieldOperationLimit.func_146179_b()) && !this.fieldOperationLimit.func_146179_b().isEmpty()) {
                    this.fieldOperationLimit.func_146180_a(s);
                }
                int num = 0;
                try {
                    num = this.fieldOperationLimit.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.fieldOperationLimit.func_146179_b());
                }
                catch (Exception e) {
                    this.fieldOperationLimit.func_146180_a("0");
                }
                this.containerCableIO.cap.operationLimit = num;
                PacketRegistry.INSTANCE.sendToServer((IMessage)new CableLimitMessage(num, this.operationItemSlot.getStack()));
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        }
    }
}

