/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.compat;

import com.jozufozu.yoyos.Yoyos;
import com.jozufozu.yoyos.client.ClientProxy;
import com.jozufozu.yoyos.common.EntityYoyo;
import com.jozufozu.yoyos.common.ItemYoyo;
import com.jozufozu.yoyos.common.ModConfig;
import com.jozufozu.yoyos.compat.ItemElementiumYoyo;
import com.jozufozu.yoyos.compat.ItemManaYoyo;
import com.jozufozu.yoyos.compat.ItemTerraYoyo;
import com.jozufozu.yoyos.compat.TerraYoyoLiningRecipe;
import com.jozufozu.yoyos.compat.YoyoLexiconEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconPage;
import vazkii.botania.api.lexicon.LexiconRecipeMappings;
import vazkii.botania.common.lexicon.LexiconData;
import vazkii.botania.common.lexicon.page.PageCraftingRecipe;
import vazkii.botania.common.lexicon.page.PageText;

@Mod.EventBusSubscriber
public class YoyoCompatibility {
    public static final ArrayList<Item> compatItems = new ArrayList();

    private static Item registerItem(IForgeRegistry<Item> registry, Item item) {
        registry.register((IForgeRegistryEntry)item);
        compatItems.add(item);
        return item;
    }

    @Optional.Method(modid="botania")
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void loadBotaniaCompatibility(RegistryEvent.Register<Item> event) {
        BotaniaAPI.blacklistEntityFromGravityRod(EntityYoyo.class);
        if (!ModConfig.botaniaYoyos.enable) {
            return;
        }
        IForgeRegistry registry = event.getRegistry();
        Item mana_cord = YoyoCompatibility.registerItem((IForgeRegistry<Item>)registry, ((Item)new Item().func_77637_a(CreativeTabs.field_78035_l).setRegistryName("yoyos", "mana_cord")).func_77655_b("yoyos.mana_cord"));
        YoyoCompatibility.registerItem((IForgeRegistry<Item>)registry, new ItemManaYoyo("manasteel_yoyo", BotaniaAPI.manasteelToolMaterial, 60).addBlockInteraction(ItemYoyo::garden));
        YoyoCompatibility.registerItem((IForgeRegistry<Item>)registry, new ItemElementiumYoyo("elementium_yoyo", BotaniaAPI.elementiumToolMaterial, 60));
        YoyoCompatibility.registerItem((IForgeRegistry<Item>)registry, new ItemTerraYoyo("terrasteel_yoyo", BotaniaAPI.terrasteelToolMaterial, 100));
        BotaniaAPI.registerManaInfusionRecipe((ItemStack)new ItemStack(mana_cord), (Object)new ItemStack(Yoyos.CORD), (int)40000);
    }

    @Optional.Method(modid="botania")
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void loadBotaniaRecipes(RegistryEvent.Register<IRecipe> event) {
        if (ModConfig.botaniaYoyos.enable) {
            event.getRegistry().register(new TerraYoyoLiningRecipe().setRegistryName("yoyos", "terra_lining"));
        }
    }

    public static void initBotania() {
        YoyoCompatibility.actuallyInitBotania();
    }

    @Optional.Method(modid="botania")
    private static void actuallyInitBotania() {
        YoyoLexiconEntry terraBlade = new YoyoLexiconEntry("terra_chaser", BotaniaAPI.categoryTools);
        terraBlade.setLexiconPages(new LexiconPage[]{new PageText("0"), new PageCraftingRecipe("1", new ResourceLocation("yoyos", "terrasteel_yoyo"))});
        if (ModConfig.botaniaYoyos.lexiconHackery) {
            YoyoCompatibility.hackPagesIntoExistingEntries();
        } else {
            YoyoLexiconEntry manasteelYoyo = new YoyoLexiconEntry("mana_yoyo", BotaniaAPI.categoryTools);
            manasteelYoyo.setLexiconPages(new LexiconPage[]{new PageText("0"), new PageCraftingRecipe("1", new ResourceLocation("yoyos", "manasteel_yoyo"))});
            LexiconEntry elementiumYoyo = new YoyoLexiconEntry("elf_yoyo", BotaniaAPI.categoryTools).setKnowledgeType(BotaniaAPI.elvenKnowledge);
            elementiumYoyo.setLexiconPages(new LexiconPage[]{new PageText("0"), new PageCraftingRecipe("1", new ResourceLocation("yoyos", "elementium_yoyo"))});
        }
    }

    @Optional.Method(modid="botania")
    private static void hackPagesIntoExistingEntries() {
        List manasteel = LexiconData.manasteelGear.pages;
        for (int i = 0; i < manasteel.size(); ++i) {
            LexiconPage page = (LexiconPage)manasteel.get(i);
            if (!"botania.page.manaGear3".equals(page.unlocalizedName)) continue;
            ResourceLocation recipeLocation = new ResourceLocation("yoyos", "manasteel_yoyo");
            manasteel.add(i + 1, new PageCraftingRecipe("yoyos.lexicon.page.mana_yoyo1", recipeLocation));
            IRecipe iRecipe = (IRecipe)ForgeRegistries.RECIPES.getValue(recipeLocation);
            if (iRecipe == null) break;
            LexiconRecipeMappings.map((ItemStack)iRecipe.func_77571_b(), (LexiconEntry)LexiconData.manasteelGear, (int)(i + 1));
            break;
        }
        List elementium = LexiconData.elfGear.pages;
        for (int i = 0; i < elementium.size(); ++i) {
            LexiconPage page = (LexiconPage)elementium.get(i);
            if (!"botania.page.elfGear7".equals(page.unlocalizedName)) continue;
            elementium.add(i + 1, new PageText("yoyos.lexicon.page.elf_yoyo00"));
            ResourceLocation recipeLocation = new ResourceLocation("yoyos", "elementium_yoyo");
            elementium.add(i + 2, new PageCraftingRecipe("yoyos.lexicon.page.elf_yoyo1", recipeLocation));
            IRecipe iRecipe = (IRecipe)ForgeRegistries.RECIPES.getValue(recipeLocation);
            if (iRecipe == null) break;
            LexiconRecipeMappings.map((ItemStack)iRecipe.func_77571_b(), (LexiconEntry)LexiconData.elfGear, (int)(i + 2));
            break;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        compatItems.forEach(ClientProxy::registerModel);
    }
}

