/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.tinkers;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.jozufozu.yoyos.Yoyos;
import com.jozufozu.yoyos.common.ModConfig;
import com.jozufozu.yoyos.tinkers.TinkersYoyos;
import com.jozufozu.yoyos.tinkers.materials.AxleMaterialStats;
import com.jozufozu.yoyos.tinkers.materials.BodyMaterialStats;
import com.jozufozu.yoyos.tinkers.materials.CordMaterialStats;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class ConfigMaterials {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOG = LogManager.getLogger((String)"Yoyo Materials");

    public static void dumpMissing(File saveLoc) {
        saveLoc.mkdirs();
        Collection materials = TinkerRegistry.getAllMaterials();
        for (Material material : materials) {
            File materialSave = new File(saveLoc, material.identifier + ".json");
            JsonObject materialJson = new JsonObject();
            JsonObject bodyStats = ConfigMaterials.dumpMissingBodyStats(material);
            JsonObject axleStats = ConfigMaterials.dumpMissingAxleStats(material);
            if (bodyStats == null && axleStats == null) continue;
            if (bodyStats != null) {
                materialJson.add("body", (JsonElement)bodyStats);
            }
            if (axleStats != null) {
                materialJson.add("axle", (JsonElement)axleStats);
            }
            try {
                FileWriter writer = new FileWriter(materialSave);
                Throwable throwable = null;
                try {
                    writer.write(GSON.toJson((JsonElement)materialJson));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (Exception e) {
                LOG.error(String.format("Error writing material \"%s\" to file: ", material.identifier), (Throwable)e);
            }
        }
    }

    @Nullable
    private static JsonObject dumpMissingBodyStats(Material material) {
        HeadMaterialStats head = (HeadMaterialStats)material.getStats("head");
        if (head == null || material.getStats("body") != null) {
            return null;
        }
        JsonObject statJson = new JsonObject();
        statJson.addProperty("attack", (Number)Float.valueOf(head.attack));
        statJson.addProperty("weight", (Number)0);
        statJson.addProperty("durability", (Number)head.durability);
        return statJson;
    }

    @Nullable
    private static JsonObject dumpMissingAxleStats(Material material) {
        HandleMaterialStats handle = (HandleMaterialStats)material.getStats("handle");
        if (handle == null || material.getStats("axle") != null) {
            return null;
        }
        JsonObject statJson = new JsonObject();
        statJson.addProperty("friction", (Number)0);
        statJson.addProperty("modifier", (Number)Float.valueOf(handle.modifier));
        return statJson;
    }

    public static void load() {
        File materialsLoc = new File(Yoyos.CONFIG_DIR, "/materials");
        if (ModConfig.configMaterials) {
            if (materialsLoc.mkdirs()) {
                ConfigMaterials.resourceMaterialsFor((name, json) -> {
                    File to = new File(materialsLoc, name + ".json");
                    if (to.exists()) {
                        return;
                    }
                    try (FileWriter writer = new FileWriter(to);){
                        writer.write(GSON.toJson((JsonElement)json));
                    }
                    catch (Exception e) {
                        LOG.error((Object)e);
                    }
                });
            }
            ConfigMaterials.loadConfigMaterials(materialsLoc);
        } else {
            ConfigMaterials.resourceMaterialsFor(ConfigMaterials::processJson);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resourceMaterialsFor(BiConsumer<String, JsonObject> action) {
        block20: {
            FileSystem filesystem = null;
            try {
                Path path;
                URL url = ConfigMaterials.class.getResource("/assets/yoyos/materials");
                if (url == null) break block20;
                URI uri = url.toURI();
                if ("file".equals(uri.getScheme())) {
                    path = Paths.get(ConfigMaterials.class.getResource("/assets/yoyos/materials").toURI());
                } else {
                    if (!"jar".equals(uri.getScheme())) {
                        LOG.error("Unsupported scheme " + uri + " trying to list all materials");
                        IOUtils.closeQuietly((Closeable)filesystem);
                        return;
                    }
                    filesystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    path = filesystem.getPath("/assets/yoyos/materials", new String[0]);
                }
                Iterator iterator = Files.walk(path, new FileVisitOption[0]).iterator();
                while (iterator.hasNext()) {
                    Path path1 = (Path)iterator.next();
                    if (!"json".equals(FilenameUtils.getExtension((String)path1.toString()))) continue;
                    String name = FilenameUtils.removeExtension((String)path1.getFileName().toString());
                    BufferedReader bufferedreader = Files.newBufferedReader(path1);
                    Throwable throwable = null;
                    try {
                        action.accept(name, (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)bufferedreader, JsonObject.class));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (bufferedreader == null) continue;
                        if (throwable != null) {
                            try {
                                bufferedreader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        bufferedreader.close();
                    }
                }
            }
            catch (IOException | URISyntaxException e) {
                LOG.error("Couldn't get a list of all material files", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly(filesystem);
            }
        }
    }

    private static void loadConfigMaterials(File file) {
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File file1 : files) {
            if (file1 == null || !file1.getAbsolutePath().endsWith(".json")) continue;
            ConfigMaterials.loadMaterialStatsFromFile(file1);
        }
    }

    private static void loadMaterialStatsFromFile(File file) {
        String name = file.getName();
        if (!name.endsWith(".json")) {
            return;
        }
        name = name.substring(0, name.indexOf(".json"));
        try {
            FileReader reader = new FileReader(file);
            JsonObject materialStats = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            reader.close();
            ConfigMaterials.processJson(name, materialStats);
        }
        catch (Exception e) {
            LOG.error(String.format("Error reading material \"%s\" from file: ", name), (Throwable)e);
        }
    }

    private static void processJson(String name, JsonObject materialStats) {
        try {
            ConfigMaterials.addStats(name, (IMaterialStats)BodyMaterialStats.deserialize(materialStats));
        }
        catch (JsonParseException e) {
            LOG.error(String.format("Error parsing body stats for material \"%s\", ", name), (Throwable)e);
        }
        try {
            ConfigMaterials.addStats(name, (IMaterialStats)AxleMaterialStats.deserialize(materialStats));
        }
        catch (JsonParseException e) {
            LOG.error(String.format("Error parsing axle stats for material \"%s\", ", name), (Throwable)e);
        }
        try {
            ConfigMaterials.addStats(name, (IMaterialStats)CordMaterialStats.deserialize(materialStats));
        }
        catch (JsonParseException e) {
            LOG.error(String.format("Error parsing cord stats for material \"%s\", ", name), (Throwable)e);
        }
    }

    private static void addStats(String material, @Nullable IMaterialStats stats) {
        if (stats == null) {
            return;
        }
        Set<IMaterialStats> statsSet = TinkersYoyos.MASTER_STATS.getOrDefault(material, Sets.newHashSet());
        statsSet.add(stats);
        if (!TinkersYoyos.MASTER_STATS.containsKey(material)) {
            TinkersYoyos.MASTER_STATS.put(material, statsSet);
        }
    }
}

