/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.tinkers.materials;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;

public class BodyMaterialStats
extends AbstractMaterialStats {
    public static final String LOC_Weight = "stat.body.weight.name";
    public static final String LOC_WeightDesc = "stat.body.weight.desc";
    public static final String COLOR_Weight = CustomFontColor.encodeColor((int)0, (int)255, (int)217);
    public final float attack;
    public final float weight;
    public final int durability;

    public BodyMaterialStats(float attack, float weight, int durability) {
        super("body");
        this.attack = attack;
        this.weight = weight;
        this.durability = durability;
    }

    public List<String> getLocalizedInfo() {
        return ImmutableList.of((Object)HeadMaterialStats.formatAttack((float)this.attack), (Object)BodyMaterialStats.formatWeight(this.weight), (Object)HeadMaterialStats.formatDurability((int)this.durability));
    }

    public List<String> getLocalizedDesc() {
        return ImmutableList.of((Object)Util.translate((String)"stat.head.attack.desc", (Object[])new Object[0]), (Object)Util.translate((String)LOC_WeightDesc, (Object[])new Object[0]), (Object)Util.translate((String)"stat.head.durability.desc", (Object[])new Object[0]));
    }

    public static String formatWeight(float weight) {
        return BodyMaterialStats.formatNumber((String)LOC_Weight, (String)COLOR_Weight, (float)weight);
    }

    @Nullable
    public static BodyMaterialStats deserialize(JsonObject material) throws JsonParseException {
        if (!JsonUtils.func_151204_g((JsonObject)material, (String)"body")) {
            return null;
        }
        JsonObject body = JsonUtils.func_152754_s((JsonObject)material, (String)"body");
        float attack = JsonUtils.func_151217_k((JsonObject)body, (String)"attack");
        float weight = JsonUtils.func_151217_k((JsonObject)body, (String)"weight");
        int durability = JsonUtils.func_151203_m((JsonObject)body, (String)"durability");
        return new BodyMaterialStats(attack, weight, durability);
    }
}

