/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.core.tiles.displays.info;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import sonar.core.api.nbt.INBTSyncable;
import sonar.logistics.api.core.tiles.displays.info.ISuffixable;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.register.LogicPath;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IElementStorageHolder;
import sonar.logistics.core.tiles.displays.info.references.ReferenceType;
import sonar.logistics.core.tiles.displays.info.types.text.StyledTitleElement;
import sonar.logistics.core.tiles.displays.info.types.text.styling.IStyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledInfo;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledStringLine;

public interface IInfo<T extends IInfo>
extends INBTSyncable {
    public String getID();

    public boolean isIdenticalInfo(T var1);

    public boolean isMatchingInfo(T var1);

    public boolean isMatchingType(IInfo var1);

    default public boolean isHeader() {
        return false;
    }

    default public void addDefaultElements(IElementStorageHolder h, InfoUUID uuid) {
        ArrayList<IDisplayElement> elements = new ArrayList<IDisplayElement>();
        this.createDefaultElements(elements, h, uuid);
        elements.forEach(e -> h.getElements().addElement((IDisplayElement)e));
    }

    default public void createDefaultElements(List<IDisplayElement> toAdd, IElementStorageHolder h, InfoUUID uuid) {
        IInfo.doCreateDefaultElements(this, toAdd, h, uuid);
    }

    public static void doCreateDefaultElements(IInfo info, List<IDisplayElement> toAdd, IElementStorageHolder h, InfoUUID uuid) {
        StyledTitleElement element = new StyledTitleElement();
        StyledStringLine line1 = new StyledStringLine(element);
        StyledStringLine line2 = new StyledStringLine(element);
        line1.setStrings(Lists.newArrayList((Object[])new IStyledString[]{new StyledInfo(uuid, ReferenceType.IDENTIFIER)}));
        if (info instanceof ISuffixable) {
            line2.setStrings(Lists.newArrayList((Object[])new IStyledString[]{new StyledInfo(uuid, ReferenceType.PREFIX), new StyledInfo(uuid, ReferenceType.RAW_INFO), new StyledInfo(uuid, ReferenceType.SUFFIX)}));
        } else {
            line2.setStrings(Lists.newArrayList((Object[])new IStyledString[]{new StyledInfo(uuid, ReferenceType.CLIENT_INFO)}));
        }
        element.setLines(Lists.newArrayList((Object[])new StyledStringLine[]{line1, line2}));
        toAdd.add(element);
    }

    public boolean isValid();

    public LogicPath getPath();

    public T setPath(LogicPath var1);

    public T copy();

    public void identifyChanges(T var1);

    public void onInfoStored();
}

