/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.requests.reference;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.client.FMLClientHandler;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.ListHelper;
import sonar.core.utils.CustomColour;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.readers.ClientLocalProvider;
import sonar.logistics.api.core.tiles.readers.IInfoProvider;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.base.gui.GuiSelectionList;
import sonar.logistics.base.gui.PL2Colours;
import sonar.logistics.base.gui.overlays.OverlayBlockSelection;
import sonar.logistics.base.requests.reference.IInfoReferenceRequirement;
import sonar.logistics.base.requests.reference.InfoReferenceRequest;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.info.InfoRenderHelper;
import sonar.logistics.core.tiles.displays.info.references.InfoReference;
import sonar.logistics.core.tiles.displays.info.references.ReferenceType;

public class GuiInfoReferenceSource
extends GuiSelectionList<Object> {
    public IInfoReferenceRequirement element;
    public List<InfoReference> selected;
    public List<InfoUUID> expanded = new ArrayList<InfoUUID>();
    public DisplayGSI gsi;
    private IInfo last;

    public GuiInfoReferenceSource(IInfoReferenceRequirement element, DisplayGSI gsi, Container container) {
        super(container, gsi.getDisplay());
        this.element = element;
        this.gsi = gsi;
        this.selected = element.getSelectedReferences();
        this.field_146999_f = 248;
        this.field_147000_g = 166;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146999_f = 248;
        this.field_147000_g = 166;
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)"Info Source", (int)this.field_146999_f, (int)6, (CustomColour)PL2Colours.white_text);
        FontHelper.textCentre((String)"Select data to display", (int)this.field_146999_f, (int)18, (CustomColour)PL2Colours.grey_text);
    }

    @Override
    public int getColour(int i, int type) {
        return PL2Colours.getDefaultSelection().getRGB();
    }

    @Override
    public boolean isPairedInfo(Object info) {
        if (info instanceof IInfoProvider && !OverlayBlockSelection.positions.isEmpty()) {
            return OverlayBlockSelection.isPositionRenderered(((IInfoProvider)info).getCoords());
        }
        return false;
    }

    @Override
    public boolean isSelectedInfo(Object info) {
        if (info instanceof InfoUUID) {
            InfoUUID uuid = (InfoUUID)info;
            boolean isSelected = false;
            for (InfoReference ref : this.selected) {
                if (!ref.uuid.equals(uuid)) continue;
                isSelected = true;
                break;
            }
            return isSelected && !this.expanded.contains(uuid);
        }
        return info instanceof InfoReference && this.selected.contains(info);
    }

    @Override
    public boolean isCategoryHeader(Object info) {
        return info instanceof ClientLocalProvider;
    }

    @Override
    public void renderInfo(Object info, int yPos) {
        if (info instanceof InfoUUID) {
            this.last = ClientInfoHandler.instance().getInfoMap().get(info);
            if (this.last != null) {
                InfoRenderHelper.renderMonitorInfoInGUI(this.last, yPos + 1, PL2Colours.white_text.getRGB());
            } else {
                FontHelper.text((String)"-", (int)InfoRenderHelper.left_offset, (int)yPos, (int)PL2Colours.white_text.getRGB());
            }
        } else if (info instanceof ClientLocalProvider) {
            ClientLocalProvider monitor = (ClientLocalProvider)info;
            FontHelper.text((String)monitor.stack.func_82833_r(), (int)InfoRenderHelper.left_offset, (int)yPos, (int)PL2Colours.white_text.getRGB());
            FontHelper.text((String)monitor.coords.getCoords().toString(), (int)InfoRenderHelper.middle_offset, (int)yPos, (int)PL2Colours.white_text.getRGB());
        } else if (info instanceof InfoReference) {
            InfoReference ref = (InfoReference)info;
            InfoRenderHelper.renderTripleStringIntoGUI("  -" + ref.refType.name(), ref.refType.getRefString(this.last), "string", yPos, PL2Colours.white_text.getRGB());
        }
    }

    @Override
    public void selectionPressed(GuiButton button, int infoPos, int buttonID, Object info) {
        if (buttonID == 0 && info instanceof InfoReference) {
            InfoReference uuid = (InfoReference)info;
            if (this.selected.size() < this.element.getReferencesRequired()) {
                ListHelper.addWithCheck(this.selected, (Object)uuid);
            } else if (!this.selected.contains(uuid)) {
                this.selected.remove(0);
                this.selected.add(uuid);
            }
        } else if (info instanceof InfoUUID) {
            if (this.expanded.contains(info)) {
                this.expanded.remove(info);
            } else {
                this.expanded.add((InfoUUID)info);
            }
        } else if (info instanceof IInfoProvider) {
            OverlayBlockSelection.addPosition(((IInfoProvider)info).getCoords(), false);
        }
    }

    protected void func_73869_a(char c, int i) throws IOException {
        if (this.isCloseKey(i) && this.selected.size() == this.element.getReferencesRequired()) {
            this.element.onGuiClosed(this.selected);
        }
        if (this.element instanceof InfoReferenceRequest) {
            FMLClientHandler.instance().showGuiScreen((Object)((InfoReferenceRequest)this.element).screen);
            return;
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void setInfo() {
        ArrayList newInfo = Lists.newArrayList((Iterable)ClientInfoHandler.instance().sortedLogicMonitors.getOrDefault(this.gsi.getDisplayGSIIdentity(), new ArrayList()));
        if (!this.expanded.isEmpty()) {
            ListIterator<InfoReference> it = newInfo.listIterator();
            while (it.hasNext()) {
                IInfo monitorInfo;
                Object next = it.next();
                if (!(next instanceof InfoUUID) || !this.expanded.contains(next) || (monitorInfo = ClientInfoHandler.instance().getInfoMap().get(next)) == null || !monitorInfo.isValid()) continue;
                for (ReferenceType type : ReferenceType.values()) {
                    it.add(new InfoReference((InfoUUID)next, type, monitorInfo.getID().hashCode()));
                }
            }
        }
        this.infoList = newInfo;
    }
}

