/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.handlers.inventories.containers.ContainerMultipartSync;
import sonar.core.helpers.ListHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.listener.ISonarListener;
import sonar.core.network.sync.DirtyPart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.ISyncableListener;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.sync.SyncableList;
import sonar.logistics.PL2;
import sonar.logistics.PL2Logging;
import sonar.logistics.api.base.IInfoManager;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.guidance.errors.IInfoError;
import sonar.logistics.base.listeners.ILogicListenable;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.base.requests.colour.GuiColourSelection;
import sonar.logistics.base.utils.LogisticsHelper;
import sonar.logistics.core.tiles.displays.DisplayHandler;
import sonar.logistics.core.tiles.displays.DisplayInfoReferenceHandler;
import sonar.logistics.core.tiles.displays.DisplayViewerHandler;
import sonar.logistics.core.tiles.displays.gsi.gui.GuiEditElementsList;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenLook;
import sonar.logistics.core.tiles.displays.gsi.modes.GSIGridMode;
import sonar.logistics.core.tiles.displays.gsi.modes.GSIModeDefault;
import sonar.logistics.core.tiles.displays.gsi.modes.GSISelectionMode;
import sonar.logistics.core.tiles.displays.gsi.modes.IGSIMode;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIElementPacketHelper;
import sonar.logistics.core.tiles.displays.gsi.render.GSIOverlays;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayElementContainer;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayGSISaveHandler;
import sonar.logistics.core.tiles.displays.gsi.storage.EditContainer;
import sonar.logistics.core.tiles.displays.info.InfoPacketHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.IClickableElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IElementStorageHolder;
import sonar.logistics.core.tiles.displays.info.elements.base.IInfoReferenceElement;
import sonar.logistics.core.tiles.displays.info.elements.base.ILookableElement;
import sonar.logistics.core.tiles.displays.info.types.InfoError;
import sonar.logistics.core.tiles.displays.info.types.text.StyledTextElement;
import sonar.logistics.core.tiles.displays.info.types.text.StyledTitleElement;
import sonar.logistics.core.tiles.displays.tiles.DisplayVectorHelper;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;
import sonar.logistics.core.tiles.displays.tiles.connected.ConnectedDisplay;
import sonar.logistics.core.tiles.displays.tiles.holographic.GuiHolographicRescaling;
import sonar.logistics.core.tiles.displays.tiles.holographic.TileAbstractHolographicDisplay;
import sonar.logistics.core.tiles.displays.tiles.holographic.TileAdvancedHolographicDisplay;
import sonar.logistics.core.tiles.displays.tiles.holographic.TileHolographicDisplay;
import sonar.logistics.network.packets.gsi.PacketGSIConnectedDisplayValidate;
import sonar.logistics.network.packets.gsi.PacketGSIInvalidate;
import sonar.logistics.network.packets.gsi.PacketGSISavedDataPacket;
import sonar.logistics.network.packets.gsi.PacketGSIStandardDisplayValidate;

public class DisplayGSI
extends DirtyPart
implements ISyncPart,
ISyncableListener,
IFlexibleGui<IDisplay>,
ISonarListener {
    public final IDisplay display;
    public List<IInfoError> errors = new ArrayList<IInfoError>();
    public List<InfoUUID> references = new ArrayList<InfoUUID>();
    public Map<InfoUUID, IInfo> cachedInfo = new HashMap<InfoUUID, IInfo>();
    public Map<IDisplayElement, List<IInfoError>> validErrors = new HashMap<IDisplayElement, List<IInfoError>>();
    public Map<Integer, DisplayElementContainer> containers = new HashMap<Integer, DisplayElementContainer>();
    public SyncableList syncParts = new SyncableList((ISyncableListener)this);
    public static final int EDIT_CONTAINER_ID = 0;
    public long lastClickTime;
    public UUID lastClickUUID;
    public IDisplayElement lookElement = null;
    public double lookX;
    public double lookY;
    private long lastLookElementUpdate;
    public SyncTagType.INT container_identity = (SyncTagType.INT)new SyncTagType.INT(0).setDefault((Object)-1);
    public SyncTagType.BOOLEAN edit_mode = (SyncTagType.BOOLEAN)new SyncTagType.BOOLEAN(2).setDefault((Object)true);
    public double[] currentScaling;
    public GSIModeDefault default_mode = new GSIModeDefault(this);
    public GSIGridMode grid_mode = new GSIGridMode(this);
    public GSISelectionMode selection_mode = new GSISelectionMode(this);
    public IGSIMode mode = this.default_mode;
    public final World world;
    public List<DisplayGSISaveHandler.DisplayGSISavedData> queuedUpdates;
    public boolean isValid;

    public DisplayGSI(IDisplay display, World world, int id) {
        this.syncParts.addParts(new IDirtyPart[]{this.container_identity, this.edit_mode});
        this.queuedUpdates = new ArrayList<DisplayGSISaveHandler.DisplayGSISavedData>();
        this.isValid = false;
        this.display = display;
        this.world = world;
        this.container_identity.setObject((Object)id);
        if (!(display instanceof ConnectedDisplay) && world.field_72995_K) {
            EditContainer.addEditContainer(this);
        }
    }

    public boolean onClicked(TileAbstractDisplay part, BlockInteractionType type, World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            return true;
        }
        if (this.display instanceof ConnectedDisplay && !((Boolean)((ConnectedDisplay)this.display).canBeRendered.getObject()).booleanValue()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("THE DISPLAY IS INCOMPLETE", new Object[0]));
            return true;
        }
        if (this.mode != this.grid_mode && type == BlockInteractionType.SHIFT_RIGHT || LogisticsHelper.isPlayerUsingOperator(player)) {
            GSIElementPacketHelper.sendGSIPacket(GSIElementPacketHelper.createEditModePacket((Boolean)this.edit_mode.getObject() == false), -1, this);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("Edit Mode: " + ((Boolean)this.edit_mode.getObject() == false), new Object[0]));
            return true;
        }
        DisplayScreenClick click = this.getClientClick(DisplayVectorHelper.createClick(player, this.display, type));
        if (click != null) {
            click.doubleClick = this.wasDoubleClick(world, player);
            if (this.mode.renderEditContainer() && this.isEditContainer(click.clickedContainer) && click.clickedElement != null) {
                this.doDefaultElementClick(part, pos, click, type, player);
                return true;
            }
            if (!this.mode.onClicked(part, pos, click, type, player) && this.mode.renderElements() && click.clickedElement != null) {
                List<IInfoError> errors = this.getErrors(click.clickedElement);
                if (errors != null && !errors.isEmpty()) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(errors.get(0).getDisplayMessage().get(0), new Object[0]));
                    return true;
                }
                this.doDefaultElementClick(part, pos, click, type, player);
            }
        }
        return true;
    }

    public boolean doDefaultElementClick(TileAbstractDisplay part, BlockPos pos, DisplayScreenClick click, BlockInteractionType type, EntityPlayer player) {
        if (click.clickedElement instanceof IClickableElement) {
            int gui = ((IClickableElement)click.clickedElement).onGSIClicked(click, player, click.subClickX, click.subClickY);
            if (gui != -1) {
                this.requestGui(part, this.world, pos, player, click.clickedElement.getElementIdentity(), gui, new NBTTagCompound());
            }
            return true;
        }
        return false;
    }

    @Nullable
    public DisplayScreenClick getClientClick(@Nullable DisplayScreenClick click) {
        if (click == null) {
            return null;
        }
        for (DisplayElementContainer container : this.containers.values()) {
            if (!container.canRender() || !container.canClickContainer(click.clickX, click.clickY)) continue;
            click.clickedContainer = container;
            Tuple<IDisplayElement, double[]> e = container.getElementFromXY(click.clickX, click.clickY);
            if (e == null) continue;
            click.clickedElement = (IDisplayElement)e.func_76341_a();
            click.subClickX = ((double[])e.func_76340_b())[0];
            click.subClickY = ((double[])e.func_76340_b())[1];
            return click;
        }
        return click;
    }

    public Tuple<IDisplayElement, double[]> getElementFromXY(double x, double y) {
        for (DisplayElementContainer container : this.containers.values()) {
            Tuple<IDisplayElement, double[]> e;
            if (!container.canRender() || !container.canClickContainer(x, y) || (e = container.getElementFromXY(x, y)) == null) continue;
            return e;
        }
        return null;
    }

    private boolean wasDoubleClick(World world, EntityPlayer player) {
        boolean doubleClick = false;
        if (world.func_82737_E() - this.lastClickTime < 10L && player.getPersistentID().equals(this.lastClickUUID)) {
            doubleClick = true;
        }
        this.lastClickTime = world.func_82737_E();
        this.lastClickUUID = player.getPersistentID();
        return doubleClick;
    }

    public void updateLookElement() {
        if (this.lastLookElementUpdate == 0L || System.currentTimeMillis() - this.lastLookElementUpdate > 50L) {
            Tuple<IDisplayElement, double[]> e;
            this.lastLookElementUpdate = System.currentTimeMillis();
            DisplayScreenLook look = GSIOverlays.getCurrentLook(this);
            this.lookElement = null;
            if (look != null && (e = this.getElementFromXY(look.lookX, look.lookY)) != null && e.func_76341_a() instanceof ILookableElement) {
                this.lookElement = (IDisplayElement)e.func_76341_a();
                this.lookX = ((double[])e.func_76340_b())[0];
                this.lookY = ((double[])e.func_76340_b())[1];
            }
        }
    }

    public void render() {
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        this.updateLookElement();
        this.mode.renderMode();
        if (this.mode.renderElements()) {
            this.getViewableContainers().forEach(DisplayElementContainer::render);
        }
    }

    public void updateScaling() {
        this.updateDisplayScaling();
        this.containers.values().forEach(DisplayElementContainer::updateActualScaling);
    }

    public Stream<DisplayElementContainer> getViewableContainers() {
        return this.containers.values().stream().filter(DisplayElementContainer::canRender);
    }

    public void updateDisplayScaling() {
        Vec3d scale = this.display.getScreenScaling();
        this.currentScaling = new double[]{scale.field_72450_a, scale.field_72448_b, scale.field_72449_c};
    }

    public double[] getDisplayScaling() {
        if (this.currentScaling == null) {
            this.updateDisplayScaling();
        }
        return this.currentScaling;
    }

    public void forEachValidUUID(Consumer<InfoUUID> action) {
        this.references.forEach(action);
    }

    public void forEachElement(Consumer<IDisplayElement> action) {
        this.forEachContainer(c -> c.getElements().forEach(action));
    }

    public void forEachContainer(Consumer<DisplayElementContainer> action) {
        this.containers.values().forEach(action);
    }

    public boolean isDisplayingUUID(InfoUUID id) {
        return this.references.contains(id);
    }

    public void onMonitoredListChanged(InfoUUID uuid, AbstractChangeableList list) {
        this.updateCachedInfo();
        this.updateScaling();
        this.forEachElement(e -> {
            if (e instanceof IInfoReferenceElement && ((IInfoReferenceElement)e).getInfoReferences().stream().anyMatch(holder -> holder.equals(uuid))) {
                ((IInfoReferenceElement)e).onChangeableListChanged(uuid, list);
            }
        });
    }

    public void onInfoChanged(InfoUUID uuid, IInfo info) {
        this.updateCachedInfo();
        this.forEachElement(e -> {
            if (e instanceof IInfoReferenceElement && ((IInfoReferenceElement)e).getInfoReferences().stream().anyMatch(holder -> holder.equals(uuid))) {
                ((IInfoReferenceElement)e).onInfoReferenceChanged(uuid, info);
            }
        });
    }

    public List<IInfoError> getCurrentErrors() {
        return this.errors;
    }

    public void addInfoError(IInfoError error) {
        if (!this.getWorld().field_72995_K && ListHelper.addWithCheck(this.errors, (Object)error)) {
            this.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ERRORS);
        }
    }

    public void addInfoErrors(List<IInfoError> errors) {
        if (!this.getWorld().field_72995_K && !errors.isEmpty() && ListHelper.addWithCheck(this.errors, errors)) {
            this.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ERRORS);
        }
    }

    public void removeInfoError(IInfoError error) {
        if (!this.getWorld().field_72995_K && this.errors.remove(error)) {
            this.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ERRORS);
        }
    }

    public void removeInfoErrors(List<IInfoError> errors) {
        if (!this.getWorld().field_72995_K && !errors.isEmpty()) {
            errors.clear();
            this.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ERRORS);
        }
    }

    public void updateErroredElements() {
        if (this.errors.isEmpty()) {
            this.validErrors.clear();
        } else {
            this.forEachElement(e -> {
                List<IInfoError> errors;
                if (e instanceof IInfoReferenceElement && !(e instanceof StyledTitleElement) && !(e instanceof StyledTextElement) && (errors = this.getValidErrors((IInfoReferenceElement)e)) != null) {
                    this.validErrors.put((IDisplayElement)e, errors);
                }
            });
        }
    }

    public boolean isErrored(IDisplayElement e) {
        return this.validErrors.containsKey(e);
    }

    @Nullable
    public List<IInfoError> getErrors(IDisplayElement e) {
        return this.validErrors.isEmpty() ? null : this.validErrors.get(e);
    }

    @Nullable
    public List<IInfoError> getValidErrors(IInfoReferenceElement e) {
        List<InfoUUID> uuids = e.getInfoReferences();
        if (!uuids.isEmpty()) {
            ArrayList<IInfoError> validErrors = new ArrayList<IInfoError>();
            for (IInfoError error : this.errors) {
                List<InfoUUID> affected = error.getAffectedUUIDs();
                boolean valid = affected.stream().anyMatch(uuids::contains);
                if (!valid) continue;
                validErrors.add(error);
            }
            return validErrors.isEmpty() ? null : validErrors;
        }
        return null;
    }

    @Nullable
    public IInfoError getValidError(InfoUUID uuid) {
        if (!this.errors.isEmpty()) {
            for (IInfoError error : this.errors) {
                if (!error.getAffectedUUIDs().contains(uuid)) continue;
                return error;
            }
        }
        return null;
    }

    public void cleanSavedErrors() {
        if (!this.getWorld().field_72995_K) {
            ArrayList<IInfoError> oldErrors = new ArrayList<IInfoError>();
            block0: for (IInfoError error : this.errors) {
                for (InfoUUID uuid : error.getAffectedUUIDs()) {
                    if (!this.references.contains(uuid)) continue;
                    continue block0;
                }
                oldErrors.add(error);
            }
            this.removeInfoErrors(oldErrors);
        }
    }

    public void updateInfoReferences() {
        if (!this.isValid() || this.getWorld().field_72995_K) {
            return;
        }
        ArrayList<InfoUUID> newReferences = new ArrayList<InfoUUID>();
        this.forEachElement(element -> {
            if (element instanceof IInfoReferenceElement) {
                ListHelper.addWithCheck((Collection)newReferences, ((IInfoReferenceElement)element).getInfoReferences());
            }
        });
        ArrayList<InfoUUID> removed = new ArrayList<InfoUUID>();
        for (InfoUUID ref : this.references) {
            if (!newReferences.contains(ref)) {
                removed.add(ref);
                continue;
            }
            newReferences.remove(ref);
        }
        if (!newReferences.isEmpty() || !removed.isEmpty()) {
            DisplayInfoReferenceHandler.doInfoReferenceConnect(this, newReferences);
            DisplayInfoReferenceHandler.doInfoReferenceDisconnect(this, removed);
            this.references.addAll(newReferences);
            this.references.removeAll(removed);
        }
        this.cleanSavedErrors();
    }

    public void validateAllInfoReferences() {
        this.updateInfoReferences();
        DisplayInfoReferenceHandler.doInfoReferenceConnect(this, this.references);
    }

    public void sendConnectedInfo(EntityPlayer player) {
        this.references.forEach(ref -> {
            ILogicListenable listen = ServerInfoHandler.instance().getNetworkTileMap().get(ref.identity);
            if (listen != null) {
                listen.getListenerList().addListener(player, new Enum[]{ListenerType.TEMPORARY_LISTENER});
            }
        });
    }

    public void updateCachedInfo() {
        IInfoManager manager = PL2.proxy.getInfoManager(this.world.field_72995_K);
        HashMap<InfoUUID, IInfo> newCache = new HashMap<InfoUUID, IInfo>();
        this.references.forEach(ref -> newCache.put((InfoUUID)ref, manager.getInfoMap().getOrDefault(ref, InfoError.noData)));
        this.cachedInfo = newCache;
    }

    public IInfo getCachedInfo(InfoUUID uuid) {
        return this.cachedInfo.get(uuid);
    }

    public void requestGui(TileAbstractDisplay display, World world, BlockPos pos, EntityPlayer player, int elementIdentity, int guiID, NBTTagCompound guiTag) {
        GSIElementPacketHelper.sendGSIPacket(GSIElementPacketHelper.createGuiRequestPacket(guiID, guiTag), elementIdentity, this);
    }

    public IDisplayElement getElementFromIdentity(int identity) {
        for (DisplayElementContainer c : this.containers.values()) {
            IDisplayElement e = c.getElements().getElementFromIdentity(identity);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public IFlexibleGui getElementFromGuiPacket(IDisplay obj, int containerID, int elementID, World world, EntityPlayer player, NBTTagCompound tag) {
        IDisplayElement e;
        DisplayElementContainer c = this.getContainer(containerID);
        if (c != null && (e = c.getElements().getElementFromIdentity(elementID)) instanceof IFlexibleGui) {
            return (IFlexibleGui)e;
        }
        return null;
    }

    public void onGuiOpened(IDisplay obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        int elementID;
        int containerID = tag.func_74764_b("CONT_ID") ? tag.func_74762_e("CONT_ID") : -1;
        int n = elementID = tag.func_74764_b("ELE_ID") ? tag.func_74762_e("ELE_ID") : -1;
        if (containerID == -1 || elementID == -1) {
            switch (id) {
                case 0: 
                case 1: {
                    TileAbstractDisplay display = (TileAbstractDisplay)obj.getActualDisplay();
                    InfoPacketHelper.sendLocalProvidersFromScreen(display, (IBlockAccess)world, display.func_174877_v(), player);
                    break;
                }
            }
        } else {
            IFlexibleGui guiHandler = this.getElementFromGuiPacket(obj, containerID, elementID, world, player, tag);
            if (guiHandler != null) {
                guiHandler.onGuiOpened((Object)obj, id, world, player, tag);
            }
        }
    }

    public Object getServerElement(IDisplay obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        int elementID;
        int containerID = tag.func_74764_b("CONT_ID") ? tag.func_74762_e("CONT_ID") : -1;
        int n = elementID = tag.func_74764_b("ELE_ID") ? tag.func_74762_e("ELE_ID") : -1;
        if (containerID == -1 || elementID == -1) {
            switch (id) {
                case 0: 
                case 1: {
                    TileAbstractDisplay display = (TileAbstractDisplay)obj.getActualDisplay();
                    return new ContainerMultipartSync((TileSonarMultipart)display);
                }
                case 2: {
                    if (!(obj instanceof TileAbstractHolographicDisplay)) break;
                    TileAbstractHolographicDisplay holographic = (TileAbstractHolographicDisplay)obj;
                    return new ContainerMultipartSync((TileSonarMultipart)holographic);
                }
            }
        } else {
            IFlexibleGui guiHandler = this.getElementFromGuiPacket(obj, containerID, elementID, world, player, tag);
            if (guiHandler != null) {
                return guiHandler.getServerElement((Object)obj, id, world, player, tag);
            }
        }
        return null;
    }

    public Object getClientElement(IDisplay obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        int elementID;
        int containerID = tag.func_74764_b("CONT_ID") ? tag.func_74762_e("CONT_ID") : -1;
        int n = elementID = tag.func_74764_b("ELE_ID") ? tag.func_74762_e("ELE_ID") : -1;
        if (containerID == -1 || elementID == -1) {
            switch (id) {
                case 0: {
                    TileAbstractDisplay display = (TileAbstractDisplay)obj.getActualDisplay();
                    return new GuiEditElementsList(this, display);
                }
                case 1: {
                    TileAbstractDisplay display = (TileAbstractDisplay)obj.getActualDisplay();
                    int element_id = tag.func_74762_e("clicked");
                    IDisplayElement element = this.getElementFromIdentity(element_id);
                    return element.getClientEditGui(display, null, world, player);
                }
                case 2: {
                    if (obj instanceof TileAdvancedHolographicDisplay) {
                        TileAdvancedHolographicDisplay holographic = (TileAdvancedHolographicDisplay)obj;
                        return new GuiHolographicRescaling((Container)new ContainerMultipartSync((TileSonarMultipart)holographic), holographic);
                    }
                    if (!(obj instanceof TileHolographicDisplay)) break;
                    TileHolographicDisplay holographic = (TileHolographicDisplay)obj;
                    return new GuiColourSelection((Container)new ContainerMultipartSync((TileSonarMultipart)holographic), holographic, holographic.getScreenColour(), i -> {
                        holographic.setScreenColour((int)i);
                        holographic.sendPropertiesToServer();
                    });
                }
            }
        } else {
            IFlexibleGui guiHandler = this.getElementFromGuiPacket(obj, containerID, elementID, world, player, tag);
            if (guiHandler != null) {
                return guiHandler.getClientElement((Object)obj, id, world, player, tag);
            }
        }
        return null;
    }

    public DisplayElementContainer getEditContainer() {
        return this.containers.get(0);
    }

    public boolean isEditContainer(DisplayElementContainer c) {
        return c != null && c.getContainerIdentity() == 0;
    }

    public DisplayElementContainer addElementContainer(double[] translate, double[] scale, double pScale) {
        int identity = this.createDisplayContainerIdentity();
        DisplayElementContainer container = new DisplayElementContainer(this, translate, scale, pScale, identity);
        this.containers.put(identity, container);
        this.validateContainer(container);
        this.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA);
        return container;
    }

    public void removeElementContainer(int containerID) {
        this.invalidateContainer(this.containers.get(containerID));
        this.containers.remove(containerID);
        this.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA);
    }

    public DisplayElementContainer getContainer(int identity) {
        return this.containers.get(identity);
    }

    public void addElement(int containerID, IDisplayElement element) {
        this.containers.get(containerID).getElements().addElement(element);
    }

    public void removeElement(int containerID, IDisplayElement element) {
        this.containers.get(containerID).getElements().removeElement(element);
    }

    public void removeElement(int identity) {
        IDisplayElement element = this.getElementFromIdentity(identity);
        if (element != null) {
            IElementStorageHolder holder = element.getHolder();
            holder.getElements().removeElement(element);
            if (holder.getElements().getElementCount() == 0) {
                if (holder instanceof DisplayElementContainer) {
                    this.containers.remove(((DisplayElementContainer)holder).getContainerIdentity());
                } else if (holder instanceof IDisplayElement) {
                    this.removeElement(((IDisplayElement)((Object)holder)).getElementIdentity());
                }
            }
        }
    }

    public void onElementAdded(IElementStorageHolder c, IDisplayElement e) {
        this.validateElement(e);
        if (!this.getWorld().field_72995_K) {
            this.updateInfoReferences();
            this.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA);
        }
    }

    public void onElementRemoved(IElementStorageHolder c, IDisplayElement e) {
        this.invalidateElement(e);
        if (!this.getWorld().field_72995_K) {
            this.updateInfoReferences();
            this.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA);
        }
    }

    public List<EntityPlayerMP> getWatchers() {
        return DisplayViewerHandler.instance().getWatchingPlayers(this);
    }

    public void forEachWatcher(Consumer<EntityPlayerMP> action) {
        this.getWatchers().forEach(action);
    }

    public void sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData type) {
        if (this.world != null && this.display != null && !this.world.field_72995_K) {
            if (!this.isValid()) {
                return;
            }
            this.queuedUpdates.add(type);
        }
    }

    public void doQueuedUpdates() {
        if (!this.queuedUpdates.isEmpty()) {
            DisplayGSISaveHandler.DisplayGSISavedData type = this.queuedUpdates.size() == 1 ? this.queuedUpdates.get(0) : DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA;
            this.forEachWatcher(listener -> PL2.network.sendTo((IMessage)new PacketGSISavedDataPacket(this, type), listener));
            this.display.onInfoContainerPacket();
            this.queuedUpdates.clear();
        }
    }

    public void sendValidatePacket(EntityPlayerMP player) {
        if (this.display instanceof ConnectedDisplay) {
            PL2.network.sendTo((IMessage)new PacketGSIConnectedDisplayValidate(this, this.display), player);
        } else if (this.display instanceof TileAbstractDisplay) {
            PL2.network.sendTo((IMessage)new PacketGSIStandardDisplayValidate((TileAbstractDisplay)this.display, this), player);
        }
    }

    public void sendInvalidatePacket(EntityPlayerMP player) {
        PL2.network.sendTo((IMessage)new PacketGSIInvalidate(this), player);
    }

    private int createDisplayContainerIdentity() {
        return ServerInfoHandler.instance().getNextIdentity();
    }

    public int getDisplayGSIIdentity() {
        return (Integer)this.container_identity.getObject();
    }

    public IDisplay getDisplay() {
        return this.display;
    }

    public World getWorld() {
        return this.world;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        DisplayGSISaveHandler.readGSIData(this, nbt, type, DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA);
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        return DisplayGSISaveHandler.writeGSIData(this, nbt, type, DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA);
    }

    public boolean canSync(NBTHelper.SyncType sync) {
        return sync.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.SPECIAL});
    }

    public String getTagName() {
        return "gsi";
    }

    public void markChanged(IDirtyPart part) {
        this.markChanged();
    }

    public EnumFacing getFacing() {
        return this.display.getCableFace();
    }

    public EnumFacing getRotation() {
        return EnumFacing.NORTH;
    }

    public void validateContainer(DisplayElementContainer c) {
        if (c != null && !this.isEditContainer(c)) {
            c.getElements().forEach(this::validateElement);
        }
    }

    public void invalidateContainer(DisplayElementContainer c) {
        if (c != null && !this.isEditContainer(c)) {
            c.getElements().forEach(this::invalidateElement);
        }
    }

    public void validateElement(IDisplayElement e) {
        if (e != null && this.isValid() && !this.isEditContainer(e.getHolder().getContainer())) {
            e.validate(this);
            PL2Logging.onGSIElementValidated(this, e);
        }
    }

    public void invalidateElement(IDisplayElement e) {
        if (e != null && !this.isEditContainer(e.getHolder().getContainer())) {
            e.invalidate(this);
            PL2Logging.onGSIElementInvalidated(this, e);
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void validate() {
        if (!this.isValid) {
            this.isValid = true;
            if (!this.world.field_72995_K) {
                PL2.proxy.getServerManager().gsiMap.put(this.getDisplayGSIIdentity(), this);
                this.references.clear();
                this.updateInfoReferences();
                this.updateCachedInfo();
                this.updateScaling();
                if (this.display instanceof ConnectedDisplay) {
                    DisplayHandler.updateWatchers(Lists.newArrayList(), (ConnectedDisplay)this.display);
                }
                this.forEachWatcher(this::sendValidatePacket);
            } else {
                PL2.proxy.getClientManager().getGSIMap().put(this.getDisplayGSIIdentity(), this);
                this.updateCachedInfo();
                this.updateScaling();
            }
            this.forEachElement(this::validateElement);
            this.display.onGSIValidate();
            PL2Logging.onGSIValidated(this);
        }
    }

    public void invalidate() {
        if (this.isValid) {
            this.isValid = false;
            if (!this.world.field_72995_K) {
                PL2.proxy.getServerManager().gsiMap.remove(this.getDisplayGSIIdentity());
                DisplayInfoReferenceHandler.doInfoReferenceDisconnect(this, this.references);
                this.forEachWatcher(this::sendInvalidatePacket);
            } else {
                PL2.proxy.getClientManager().getGSIMap().remove(this.getDisplayGSIIdentity());
            }
            this.forEachElement(this::invalidateElement);
            this.display.onGSIInvalidate();
            PL2Logging.onGSIInvalidated(this);
        }
    }
}

