/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi.packets;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.interaction.GSIInteractionHelper;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIClickPacket;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayElementContainer;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;
import sonar.logistics.core.tiles.displays.tiles.connected.ConnectedDisplay;
import sonar.logistics.network.packets.gsi.PacketGSIClick;

public class GSIClickPacketHelper {
    public static final String PACKET_ID = "PktID";
    public static GSIClickPacket.IGSIClickPacketHandler handler = GSIClickPacketHelper::runGSIClickPacket;

    public static GSIClickPacket.IGSIClickPacketHandler getGSIHandler(IInfo info) {
        return info instanceof GSIClickPacket.IGSIClickPacketHandler ? (GSIClickPacket.IGSIClickPacketHandler)((Object)info) : handler;
    }

    public static void sendGSIClickPacket(NBTTagCompound tag, DisplayElementContainer container, DisplayScreenClick click) {
        if (!tag.func_82582_d()) {
            PL2.network.sendToServer((IMessage)new PacketGSIClick(container.getContainerIdentity(), click, tag));
        }
    }

    public static void runGSIClickPacket(DisplayGSI gsi, DisplayScreenClick click, EntityPlayer player, NBTTagCompound clickTag) {
        GSIClickPacketHelper.readPacketID((NBTTagCompound)clickTag).logic.runGSIClickPacket(gsi, click, player, clickTag);
    }

    public static NBTTagCompound createBasicPacket(GSIClickPacket packet) {
        return GSIClickPacketHelper.writePacketID(new NBTTagCompound(), packet);
    }

    public static NBTTagCompound writePacketID(NBTTagCompound tag, GSIClickPacket packet) {
        tag.func_74768_a(PACKET_ID, packet.ordinal());
        return tag;
    }

    public static GSIClickPacket readPacketID(NBTTagCompound tag) {
        return GSIClickPacket.values()[tag.func_74762_e(PACKET_ID)];
    }

    public static NBTTagCompound createItemClickPacket(StoredItemStack stack, int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        GSIClickPacketHelper.writePacketID(tag, GSIClickPacket.ITEM_CLICK);
        tag.func_74768_a("networkID", networkID);
        if (stack != null) {
            stack.writeData(tag, NBTHelper.SyncType.SAVE);
        }
        return tag;
    }

    public static void doItemPacket(DisplayGSI gsi, DisplayScreenClick click, EntityPlayer player, NBTTagCompound clickTag) {
        StoredItemStack clicked = (StoredItemStack)NBTHelper.instanceNBTSyncable(StoredItemStack.class, (NBTTagCompound)clickTag);
        int networkID = clickTag.func_74762_e("networkID");
        GSIInteractionHelper.screenItemStackClicked(networkID, clicked.item.func_190926_b() ? null : clicked, click, player, clickTag);
    }

    public static NBTTagCompound createFluidClickPacket(StoredFluidStack stack, int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        GSIClickPacketHelper.writePacketID(tag, GSIClickPacket.FLUID_CLICK);
        tag.func_74768_a("networkID", networkID);
        if (stack != null) {
            stack.writeData(tag, NBTHelper.SyncType.SAVE);
        }
        return tag;
    }

    public static void doFluidPacket(DisplayGSI gsi, DisplayScreenClick click, EntityPlayer player, NBTTagCompound clickTag) {
        StoredFluidStack clicked = (StoredFluidStack)NBTHelper.instanceNBTSyncable(StoredFluidStack.class, (NBTTagCompound)clickTag);
        GSIInteractionHelper.onScreenFluidStackClicked(clickTag.func_74762_e("networkID"), clicked.fluid == null ? null : clicked, click, player, clickTag);
    }

    public static void doSourceButtonPacket(DisplayGSI gsi, DisplayScreenClick click, EntityPlayer player, NBTTagCompound clickTag) {
        IDisplay display = gsi.getDisplay();
        if (display instanceof ConnectedDisplay) {
            display = ((ConnectedDisplay)display).getTopLeftScreen();
        }
        if (display instanceof TileAbstractDisplay) {
            TileAbstractDisplay tile = (TileAbstractDisplay)display;
            int slotID = tile.getSlotID();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a(slotID == -1 ? FlexibleGuiHandler.TILEENTITY : FlexibleGuiHandler.MULTIPART, true);
            tag.func_74768_a(FlexibleGuiHandler.SLOT_ID, slotID);
        }
    }
}

