/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types;

import java.util.ArrayList;
import sonar.core.network.sync.BaseSyncListPart;
import sonar.core.network.sync.ICheckableSyncPart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.ISyncableListener;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValueInfo;
import sonar.logistics.api.core.tiles.displays.info.register.LogicPath;
import sonar.logistics.core.tiles.displays.info.types.general.InfoMonitoredValue;

public abstract class BaseInfo<T extends IInfo>
extends BaseSyncListPart
implements IInfo<T>,
ISyncableListener,
IMonitoredValueInfo<T> {
    private LogicPath path;

    @Override
    public LogicPath getPath() {
        return this.path;
    }

    @Override
    public T setPath(LogicPath path) {
        this.path = path;
        return (T)this;
    }

    @Override
    public boolean isHeader() {
        return false;
    }

    @Override
    public void onInfoStored() {
    }

    public boolean equals(Object object) {
        if (object instanceof IInfo) {
            IInfo info = (IInfo)object;
            return info.isHeader() && this.isHeader() || this.isMatchingType(info) && this.isMatchingInfo(info) && this.isIdenticalInfo(info);
        }
        return false;
    }

    @Override
    public void identifyChanges(T newInfo) {
        ArrayList parts = this.syncList.getStandardSyncParts();
        ArrayList infoParts = this.syncList.getStandardSyncParts();
        for (int i = 0; i < parts.size(); ++i) {
            ISyncPart toCheck = (ISyncPart)infoParts.get(i);
            if (toCheck instanceof ICheckableSyncPart) {
                if (((ICheckableSyncPart)parts.get(i)).equalPart(toCheck)) continue;
                toCheck.getListener().markChanged((IDirtyPart)toCheck);
                continue;
            }
            toCheck.getListener().markChanged((IDirtyPart)toCheck);
        }
    }

    @Override
    public IMonitoredValue<T> createMonitoredValue() {
        return new InfoMonitoredValue<BaseInfo>(this);
    }
}

