/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.channels;

import java.util.List;
import net.minecraft.item.ItemStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockCoords;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncCoords;
import sonar.core.network.sync.SyncNBTAbstract;
import sonar.logistics.api.asm.ASMInfo;
import sonar.logistics.api.core.tiles.displays.info.IComparableInfo;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.INameableInfo;
import sonar.logistics.api.core.tiles.displays.info.comparators.ComparableObject;
import sonar.logistics.core.tiles.displays.info.types.BaseInfo;

@ASMInfo(id="coords", modid="practicallogistics2")
public class MonitoredBlockCoords
extends BaseInfo<MonitoredBlockCoords>
implements INameableInfo<MonitoredBlockCoords>,
IComparableInfo<MonitoredBlockCoords> {
    public static final String id = "coords";
    private SyncCoords syncCoords = new SyncCoords(1);
    private final SyncNBTAbstract<StoredItemStack> blockStack = new SyncNBTAbstract(StoredItemStack.class, 2);

    public MonitoredBlockCoords() {
        this.syncList.addParts(new IDirtyPart[]{this.syncCoords, this.blockStack});
    }

    public MonitoredBlockCoords(BlockCoords coords, ItemStack blockStack) {
        this.syncList.addParts(new IDirtyPart[]{this.syncCoords, this.blockStack});
        this.syncCoords.setCoords(coords);
        this.blockStack.setObject((INBTSyncable)new StoredItemStack(blockStack));
    }

    @Override
    public boolean isIdenticalInfo(MonitoredBlockCoords info) {
        return true;
    }

    @Override
    public boolean isMatchingInfo(MonitoredBlockCoords info) {
        return info.syncCoords.getCoords().equals((Object)this.syncCoords.getCoords());
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof MonitoredBlockCoords;
    }

    @Override
    public String getClientIdentifier() {
        return ((StoredItemStack)this.blockStack.getObject()).getItemStack().func_82833_r();
    }

    @Override
    public String getClientObject() {
        return this.syncCoords.getCoords().toString();
    }

    @Override
    public String getClientType() {
        return "position";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MonitoredBlockCoords) {
            MonitoredBlockCoords monitoredCoords = (MonitoredBlockCoords)obj;
            return monitoredCoords.getCoords().equals((Object)this.getCoords()) && monitoredCoords.getUnlocalizedName().equals(this.getUnlocalizedName());
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.getCoords() != null;
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public MonitoredBlockCoords copy() {
        return new MonitoredBlockCoords(this.getCoords(), ((StoredItemStack)this.blockStack.getObject()).getItemStack());
    }

    public BlockCoords getCoords() {
        return this.syncCoords.getCoords();
    }

    public String getUnlocalizedName() {
        return ((StoredItemStack)this.blockStack.getObject()).getItemStack().func_77977_a();
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        BlockCoords coords = this.syncCoords.getCoords();
        objects.add(new ComparableObject(this, "x", coords.getX()));
        objects.add(new ComparableObject(this, "y", coords.getY()));
        objects.add(new ComparableObject(this, "z", coords.getZ()));
        return objects;
    }
}

