/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.tiles.holographic;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.xml.ws.Holder;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.FMLCommonHandler;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.IGuiOrigin;
import sonar.core.client.gui.widgets.ScrollerOrientation;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.helpers.FontHelper;
import sonar.logistics.base.gui.GuiLogistics;
import sonar.logistics.base.gui.buttons.LogisticsButton;
import sonar.logistics.base.requests.colour.CustomColourButton;
import sonar.logistics.base.requests.colour.GuiColourSelection;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.tiles.holographic.TileAbstractHolographicDisplay;
import sonar.logistics.core.tiles.displays.tiles.holographic.TileAdvancedHolographicDisplay;

public class GuiHolographicRescaling
extends GuiLogistics {
    public TileAdvancedHolographicDisplay display;
    public HolographicScroller pitchScroller;
    public HolographicScroller yawScroller;
    public HolographicScroller rollScroller;
    public HolographicScroller widthScroller;
    public HolographicScroller heightScroller;
    public HolographicScroller xScroller;
    public HolographicScroller yScroller;
    public HolographicScroller zScroller;
    public List<HolographicScroller> scrollers;

    public GuiHolographicRescaling(Container container, TileAdvancedHolographicDisplay display) {
        super(container, display);
        this.display = display;
        this.field_147000_g = 220;
        this.field_146999_f = 200;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new CustomColourButton(this, 0, this.field_147003_i + 4, this.field_147009_r + 4, "Select Screen Colour"){

            @Override
            public boolean isSelected() {
                return false;
            }
        });
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 1, this.field_147003_i + 30, this.field_147009_r + 4, 32, 32, "Reset Colour", ""));
        this.pitchScroller = new HolographicScroller(this.field_147003_i + 10, this.field_147009_r + 30, 12, 180){

            @Override
            public void set(TileAdvancedHolographicDisplay display) {
                this.currentScroll = (float)(display.getPitch() + 90.0) / 180.0f;
            }

            @Override
            public boolean update(TileAdvancedHolographicDisplay display) {
                double newPitch = (int)(this.currentScroll * 180.0f) - 90;
                if (display.getPitch() != newPitch) {
                    display.setRotation(newPitch, display.getYaw(), display.getRoll());
                    return true;
                }
                return false;
            }
        };
        this.pitchScroller.setOrientation(ScrollerOrientation.HORIZONTAL);
        this.yawScroller = new HolographicScroller(this.field_147003_i + 10, this.field_147009_r + 55, 12, 180){

            @Override
            public void set(TileAdvancedHolographicDisplay display) {
                this.currentScroll = (float)display.getYaw() / 360.0f;
            }

            @Override
            public boolean update(TileAdvancedHolographicDisplay display) {
                double newYaw = (int)(this.currentScroll * 360.0f);
                if (display.getYaw() != newYaw) {
                    display.setRotation(display.getPitch(), newYaw, display.getRoll());
                    return true;
                }
                return false;
            }
        };
        this.yawScroller.setOrientation(ScrollerOrientation.HORIZONTAL);
        this.rollScroller = new HolographicScroller(this.field_147003_i + 10, this.field_147009_r + 80, 12, 180){

            @Override
            public void set(TileAdvancedHolographicDisplay display) {
                this.currentScroll = (float)display.getRoll() / 360.0f;
            }

            @Override
            public boolean update(TileAdvancedHolographicDisplay display) {
                double newRoll = (int)(this.currentScroll * 360.0f);
                if (display.getRoll() != newRoll) {
                    display.setRotation(display.getPitch(), display.getYaw(), newRoll);
                    return true;
                }
                return false;
            }
        };
        this.rollScroller.setOrientation(ScrollerOrientation.HORIZONTAL);
        this.widthScroller = new HolographicScroller(this.field_147003_i + 10, this.field_147009_r + 105, 12, 180){

            @Override
            public void set(TileAdvancedHolographicDisplay display) {
                this.currentScroll = (float)display.getWidth() / 32.0f;
            }

            @Override
            public boolean update(TileAdvancedHolographicDisplay display) {
                double newWidth = Math.max(0.5, DisplayElementHelper.toNearestMultiple(this.currentScroll * 32.0f, 32.0, 0.25));
                if (display.getWidth() != newWidth) {
                    display.setScaling(newWidth, display.getHeight(), display.getDepth());
                    return true;
                }
                return false;
            }
        };
        this.widthScroller.setOrientation(ScrollerOrientation.HORIZONTAL);
        this.heightScroller = new HolographicScroller(this.field_147003_i + 10, this.field_147009_r + 130, 12, 180){

            @Override
            public void set(TileAdvancedHolographicDisplay display) {
                this.currentScroll = (float)display.getHeight() / 32.0f;
            }

            @Override
            public boolean update(TileAdvancedHolographicDisplay display) {
                double newHeight = Math.max(0.5, DisplayElementHelper.toNearestMultiple(this.currentScroll * 32.0f, 32.0, 0.25));
                if (display.getHeight() != newHeight) {
                    display.setScaling(display.getWidth(), newHeight, display.getDepth());
                    return true;
                }
                return false;
            }
        };
        this.heightScroller.setOrientation(ScrollerOrientation.HORIZONTAL);
        this.xScroller = new HolographicScroller(this.field_147003_i + 10, this.field_147009_r + 155, 12, 180){

            @Override
            public void set(TileAdvancedHolographicDisplay display) {
                this.currentScroll = (float)(display.getScreenOffset().field_72450_a + 16.0) / 32.0f;
            }

            @Override
            public boolean update(TileAdvancedHolographicDisplay display) {
                double newX = DisplayElementHelper.toNearestMultiple(this.currentScroll * 32.0f, 32.0, 0.25) - 16.0;
                if (display.getScreenOffset().field_72450_a != newX) {
                    display.setScreenOffset(newX, display.getScreenOffset().field_72448_b, display.getScreenOffset().field_72449_c);
                    return true;
                }
                return false;
            }
        };
        this.xScroller.setOrientation(ScrollerOrientation.HORIZONTAL);
        this.yScroller = new HolographicScroller(this.field_147003_i + 10, this.field_147009_r + 180, 12, 180){

            @Override
            public void set(TileAdvancedHolographicDisplay display) {
                this.currentScroll = (float)(display.getScreenOffset().field_72448_b + 16.0) / 32.0f;
            }

            @Override
            public boolean update(TileAdvancedHolographicDisplay display) {
                double newY = DisplayElementHelper.toNearestMultiple(this.currentScroll * 32.0f, 32.0, 0.25) - 16.0;
                if (display.getScreenOffset().field_72448_b != newY) {
                    display.setScreenOffset(display.getScreenOffset().field_72450_a, newY, display.getScreenOffset().field_72449_c);
                    return true;
                }
                return false;
            }
        };
        this.yScroller.setOrientation(ScrollerOrientation.HORIZONTAL);
        this.zScroller = new HolographicScroller(this.field_147003_i + 10, this.field_147009_r + 205, 12, 180){

            @Override
            public void set(TileAdvancedHolographicDisplay display) {
                this.currentScroll = (float)(display.getScreenOffset().field_72449_c + 16.0) / 32.0f;
            }

            @Override
            public boolean update(TileAdvancedHolographicDisplay display) {
                double newZ = DisplayElementHelper.toNearestMultiple(this.currentScroll * 32.0f, 32.0, 0.25) - 16.0;
                if (display.getScreenOffset().field_72449_c != newZ) {
                    display.setScreenOffset(display.getScreenOffset().field_72450_a, display.getScreenOffset().field_72448_b, newZ);
                    return true;
                }
                return false;
            }
        };
        this.zScroller.setOrientation(ScrollerOrientation.HORIZONTAL);
        this.scrollers = Lists.newArrayList((Object[])new HolographicScroller[]{this.pitchScroller, this.yawScroller, this.rollScroller, this.widthScroller, this.heightScroller, this.xScroller, this.yScroller, this.zScroller});
        this.setScrollers();
    }

    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof CustomColourButton) {
            FMLCommonHandler.instance().showGuiScreen((Object)IGuiOrigin.withOrigin((IGuiOrigin)new GuiColourSelection(this.field_147002_h, this.entity, this.display.getScreenColour(), i -> this.display.screenColour.setObject(i)), (Object)((Object)this)));
            return;
        }
        if (button instanceof LogisticsButton) {
            switch (button.field_146127_k) {
                case 1: {
                    this.display.screenColour.setObject((Object)TileAbstractHolographicDisplay.DEFAULT_COLOUR);
                }
            }
        }
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)"Holographic Display Scaling", (int)this.field_146999_f, (int)4, (int)-1);
        FontHelper.text((String)("Pitch: " + this.display.getPitch() + "\u00b0"), (int)12, (int)20, (int)-1);
        FontHelper.text((String)("Yaw: " + this.display.getYaw() + "\u00b0"), (int)12, (int)45, (int)-1);
        FontHelper.text((String)("Roll: " + this.display.getRoll() + "\u00b0"), (int)12, (int)70, (int)-1);
        FontHelper.text((String)("Screen Width: " + this.display.getWidth()), (int)12, (int)95, (int)-1);
        FontHelper.text((String)("Screen Height: " + this.display.getHeight()), (int)12, (int)120, (int)-1);
        FontHelper.text((String)("Offset X: " + this.display.getScreenOffset().field_72450_a), (int)12, (int)145, (int)-1);
        FontHelper.text((String)("Offset Y: " + this.display.getScreenOffset().field_72448_b), (int)12, (int)170, (int)-1);
        FontHelper.text((String)("Offset Z: " + this.display.getScreenOffset().field_72449_c), (int)12, (int)195, (int)-1);
    }

    @Override
    public void func_146976_a(float partialTicks, int x, int y) {
        super.func_146976_a(partialTicks, x, y);
        this.scrollers.forEach(s -> this.renderScroller((SonarScroller)s));
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        this.scrollers.forEach(s -> s.drawScreen(x, y, true));
        this.updateScrollers();
    }

    public void setScrollers() {
        this.scrollers.forEach(s -> s.set(this.display));
    }

    public void updateScrollers() {
        Holder shouldUpdate = new Holder((Object)false);
        this.scrollers.forEach(s -> {
            if (s.update(this.display)) {
                shouldUpdate.value = true;
            }
        });
        if (((Boolean)shouldUpdate.value).booleanValue()) {
            this.display.getHolographicEntity().ifPresent(entity -> entity.setSizingFromDisplay(this.display));
        }
    }

    protected void func_73869_a(char c, int i) throws IOException {
        if (this.isCloseKey(i)) {
            this.display.sendPropertiesToServer();
        }
        super.func_73869_a(c, i);
    }

    public abstract class HolographicScroller
    extends SonarScroller {
        public HolographicScroller(int scrollerLeft, int scrollerStart, int length, int width) {
            super(scrollerLeft, scrollerStart, length, width);
        }

        public abstract void set(TileAdvancedHolographicDisplay var1);

        public abstract boolean update(TileAdvancedHolographicDisplay var1);
    }
}

