/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.base;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncCoords;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.sync.SyncUUID;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.connections.EnumCableConnection;
import sonar.logistics.api.core.tiles.connections.EnumCableConnectionType;
import sonar.logistics.api.core.tiles.connections.EnumCableRenderSize;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.api.core.tiles.displays.info.lists.UniversalChangeableList;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.api.core.tiles.readers.INetworkReader;
import sonar.logistics.api.core.tiles.readers.channels.INetworkChannels;
import sonar.logistics.api.core.tiles.readers.channels.INetworkHandler;
import sonar.logistics.base.channels.ChannelList;
import sonar.logistics.base.channels.ChannelType;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.base.listeners.PL2ListenerList;
import sonar.logistics.base.utils.slots.EnumDisplayFaceSlot;
import sonar.logistics.core.tiles.base.TileSidedLogistics;
import sonar.logistics.core.tiles.displays.info.types.channels.MonitoredBlockCoords;
import sonar.logistics.core.tiles.displays.info.types.channels.MonitoredEntity;
import sonar.logistics.network.sync.SyncMonitoredType;

public abstract class TileAbstractReader<T extends IInfo>
extends TileSidedLogistics
implements INetworkReader<T>,
IByteBufTile,
IFlexibleGui {
    public static final int ADD = -9;
    public static final int PAIRED = -10;
    public static final int ALL = 100;
    public PL2ListenerList listeners = new PL2ListenerList(this, ListenerType.ALL.size());
    public ChannelList list = new ChannelList(this.getIdentity(), this.channelType(), -2);
    protected List<INetworkHandler> validHandlers = null;
    public SyncMonitoredType<T> selectedInfo = new SyncMonitoredType(-5);
    public SyncTagType.BOOLEAN hasMonitor = new SyncTagType.BOOLEAN(-4);
    public int lastPos = -1;
    public SyncUUID lastSelectedUUID = new SyncUUID(-10);
    public SyncCoords lastSelected = new SyncCoords(-11);

    public TileAbstractReader() {
        this.syncList.addParts(new IDirtyPart[]{this.list, this.hasMonitor});
    }

    @Override
    public EnumCableRenderSize getCableRenderSize(EnumFacing dir) {
        return dir == this.getCableFace() ? EnumCableRenderSize.HALF : EnumCableRenderSize.CABLE;
    }

    @Override
    public EnumCableConnection canConnect(int registryID, EnumCableConnectionType type, EnumFacing dir, boolean internal) {
        EnumFacing toCheck;
        EnumFacing enumFacing = toCheck = internal ? dir : dir.func_176734_d();
        return toCheck == this.getCableFace() ? EnumCableConnection.NETWORK : (toCheck == this.getCableFace().func_176734_d() ? EnumCableConnection.VISUAL : EnumCableConnection.NONE);
    }

    public abstract List<INetworkHandler> addValidHandlers(List<INetworkHandler> var1);

    @Override
    public AbstractChangeableList<T> getViewableList(AbstractChangeableList<T> updateList, InfoUUID uuid, Map<NodeConnection, AbstractChangeableList<T>> channels, List<NodeConnection> usedChannels) {
        ChannelList readerChannels = this.getChannels();
        for (Map.Entry<NodeConnection, AbstractChangeableList<T>> entry : channels.entrySet()) {
            if (!readerChannels.isMonitored(entry.getKey())) continue;
            for (IMonitoredValue<T> coordInfo : entry.getValue().getList()) {
                if (!this.canMonitorInfo(coordInfo, uuid, channels, usedChannels)) continue;
                updateList.add(coordInfo.getSaveableInfo());
            }
            usedChannels.add(entry.getKey());
            if (this.channelType() != ChannelType.SINGLE) continue;
            break;
        }
        return updateList;
    }

    @Override
    public List<NodeConnection> getUsedChannels(Map<NodeConnection, AbstractChangeableList<T>> channels) {
        ArrayList<NodeConnection> usedChannels = new ArrayList<NodeConnection>();
        ChannelList readerChannels = this.getChannels();
        for (Map.Entry<NodeConnection, AbstractChangeableList<T>> entry : channels.entrySet()) {
            if (!readerChannels.isMonitored(entry.getKey())) continue;
            usedChannels.add(entry.getKey());
        }
        return usedChannels;
    }

    public boolean canMonitorInfo(IMonitoredValue<T> info, InfoUUID uuid, Map<NodeConnection, AbstractChangeableList<T>> channels, List<NodeConnection> usedChannels) {
        return true;
    }

    @Override
    public List<INetworkHandler> getValidHandlers() {
        if (this.validHandlers == null) {
            this.validHandlers = this.addValidHandlers(new ArrayList<INetworkHandler>());
        }
        return this.validHandlers;
    }

    @Nullable
    public AbstractChangeableList<T> getMonitoredList() {
        InfoUUID id = new InfoUUID(this.getIdentity(), 0);
        return PL2.proxy.getInfoManager(this.isClient()).getChangeableListMap().getOrDefault(id, UniversalChangeableList.newChangeableList());
    }

    @Override
    public ChannelList getChannels() {
        return this.list;
    }

    @Override
    public void sendCoordsToServer(IInfo info, int channelID) {
        if (info instanceof MonitoredBlockCoords) {
            this.lastSelected.setCoords(((MonitoredBlockCoords)info).getCoords());
            this.sendByteBufPacket(-3);
        }
        if (info instanceof MonitoredEntity) {
            this.lastSelectedUUID.setObject(((MonitoredEntity)info).getUUID());
            this.sendByteBufPacket(-4);
        }
    }

    @Override
    public PL2ListenerList getListenerList() {
        return this.listeners;
    }

    @Override
    public void onListenerAdded(ListenerTally<PlayerListener> tally) {
        super.onListenerAdded(tally);
        SonarMultipartHelper.sendMultipartSyncToPlayer((TileSonarMultipart)this, (EntityPlayerMP)((PlayerListener)tally.listener).player);
    }

    @Override
    public void addInfo(List<String> info) {
        super.addInfo(info);
        info.add("Channels Configured: " + !this.list.hasChannels());
        info.add("Max Info: " + this.getMaxInfo());
    }

    public void markChanged(IDirtyPart part) {
        super.markChanged(part);
        if (part == this.list) {
            for (INetworkHandler handler : this.getValidHandlers()) {
                INetworkChannels channels = this.network.getNetworkChannels(handler.getChannelsType());
                if (channels == null) continue;
                channels.onChannelsChanged();
            }
        }
    }

    public void onFirstTick() {
        super.onFirstTick();
        if (this.isServer()) {
            Optional display = this.info == null ? Optional.empty() : this.info.getContainer().getPartTile((IPartSlot)EnumDisplayFaceSlot.fromFace(this.getCableFace()));
            this.hasMonitor.setObject((Object)(display.isPresent() && display.get() instanceof IDisplay ? 1 : 0));
            SonarMultipartHelper.sendMultipartUpdateSyncAround((TileSonarMultipart)this, (int)128);
        }
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case -5: {
                this.list.writeToBuf(buf);
                break;
            }
            case -4: {
                this.lastSelectedUUID.writeToBuf(buf);
                break;
            }
            case -3: {
                this.lastSelected.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case -5: {
                this.list.readFromBuf(buf);
                break;
            }
            case -4: {
                this.lastSelectedUUID.readFromBuf(buf);
                this.list.give(this.lastSelectedUUID.getUUID());
                this.sendByteBufPacket(-5);
                break;
            }
            case -3: {
                this.lastSelected.readFromBuf(buf);
                this.list.give(this.lastSelected.getCoords());
                this.sendByteBufPacket(-5);
            }
        }
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 1: {
                this.getNetwork().sendConnectionsPacket(player);
            }
        }
    }
}

