/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.energy;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.api.energy.StoredEnergyStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.handlers.energy.EnergyTransferHandler;
import sonar.core.handlers.energy.IEnergyTransferProxy;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncCoords;
import sonar.core.network.sync.SyncEnergyType;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.SortingDirection;
import sonar.logistics.PL2Blocks;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.api.core.tiles.readers.ILogicListSorter;
import sonar.logistics.api.core.tiles.readers.channels.INetworkHandler;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.channels.ChannelType;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.guidance.errors.ErrorMessage;
import sonar.logistics.core.tiles.displays.info.types.BaseInfo;
import sonar.logistics.core.tiles.displays.info.types.LogicInfoList;
import sonar.logistics.core.tiles.displays.info.types.channels.MonitoredBlockCoords;
import sonar.logistics.core.tiles.displays.info.types.energy.MonitoredEnergyStack;
import sonar.logistics.core.tiles.readers.base.TileAbstractListReader;
import sonar.logistics.core.tiles.readers.energy.ContainerEnergyReader;
import sonar.logistics.core.tiles.readers.energy.EnergyReader;
import sonar.logistics.core.tiles.readers.energy.EnergySorter;
import sonar.logistics.core.tiles.readers.energy.GuiEnergyReader;
import sonar.logistics.core.tiles.readers.energy.handling.EnergyNetworkHandler;

public class TileEnergyReader
extends TileAbstractListReader<MonitoredEnergyStack>
implements IByteBufTile {
    public static final ErrorMessage[] validStates = new ErrorMessage[]{ErrorMessage.NO_NETWORK};
    public SyncCoords selected = new SyncCoords(1);
    public SyncEnum<SortingDirection> sortingOrder = (SyncEnum)new SyncEnum((Enum[])SortingDirection.values(), 2).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncEnum<EnergyReader.Modes> setting = (SyncEnum)new SyncEnum((Enum[])EnergyReader.Modes.values(), 3).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncEnergyType energyType = new SyncEnergyType(4);
    public EnergySorter energy_sorter = new EnergySorter(){

        @Override
        public SortingDirection getDirection() {
            return (SortingDirection)TileEnergyReader.this.sortingOrder.getObject();
        }

        @Override
        public EnergyReader.SortingType getType() {
            return EnergyReader.SortingType.NAME;
        }
    };
    public boolean sorting_changed = true;

    public TileEnergyReader() {
        this.syncList.addParts(new IDirtyPart[]{this.selected, this.sortingOrder, this.setting, this.energyType});
    }

    @Override
    public List<INetworkHandler> addValidHandlers(List<INetworkHandler> handlers) {
        handlers.add(EnergyNetworkHandler.INSTANCE);
        return handlers;
    }

    @Override
    public int getMaxInfo() {
        return 1;
    }

    @Override
    public AbstractChangeableList<MonitoredEnergyStack> sortMonitoredList(AbstractChangeableList<MonitoredEnergyStack> updateInfo, int channelID) {
        return this.energy_sorter.sortSaveableList(updateInfo);
    }

    @Override
    public void setMonitoredInfo(AbstractChangeableList<MonitoredEnergyStack> updateInfo, List<NodeConnection> usedChannels, InfoUUID uuid) {
        BaseInfo info = null;
        block0 : switch ((EnergyReader.Modes)this.setting.getObject()) {
            case STORAGE: {
                if (this.selected.getCoords() == null) break;
                for (IMonitoredValue<MonitoredEnergyStack> value : updateInfo.getList()) {
                    MonitoredEnergyStack stack = value.getSaveableInfo();
                    if (!stack.getMonitoredCoords().getCoords().equals((Object)this.selected.getCoords())) continue;
                    MonitoredEnergyStack convert = stack.copy();
                    convert.getEnergyStack().convertEnergyType(this.energyType.getEnergyType(), (IEnergyTransferProxy)EnergyTransferHandler.PROXY_SC);
                    info = convert;
                    break block0;
                }
                break;
            }
            case STORAGES: {
                LogicInfoList list = new LogicInfoList(this.getIdentity(), "energy", this.getNetworkID());
                list.listSorter = this.energy_sorter;
                info = list;
                break;
            }
            case TOTAL: {
                MonitoredEnergyStack energy = new MonitoredEnergyStack(new StoredEnergyStack(this.energyType.getEnergyType()), new MonitoredBlockCoords(this.getCoords(), new ItemStack(PL2Blocks.energy_reader)), new StoredItemStack(new ItemStack(PL2Blocks.energy_reader)));
                for (IMonitoredValue<MonitoredEnergyStack> value : updateInfo.getList()) {
                    MonitoredEnergyStack stack = value.getSaveableInfo();
                    MonitoredEnergyStack convert = stack.copy();
                    convert.getEnergyStack().convertEnergyType(this.energyType.getEnergyType(), (IEnergyTransferProxy)EnergyTransferHandler.PROXY_SC);
                    energy = (MonitoredEnergyStack)energy.joinInfo(convert);
                }
                info = energy;
                break;
            }
        }
        ServerInfoHandler.instance().changeInfo(this, uuid, info);
        if (this.sorting_changed) {
            ServerInfoHandler.instance().markChanged(this, uuid);
            this.sorting_changed = false;
        }
    }

    @Override
    public ChannelType channelType() {
        return ChannelType.UNLIMITED;
    }

    @Override
    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case -10: 
            case -9: {
                this.selected.writeToBuf(buf);
                return;
            }
        }
        super.writePacket(buf, id);
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        if (id == this.sortingOrder.id) {
            this.sorting_changed = true;
        }
        switch (id) {
            case -9: {
                this.selected.readFromBuf(buf);
                return;
            }
        }
        super.readPacket(buf, id);
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new ContainerEnergyReader(player, this);
            }
        }
        return null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new GuiEnergyReader(player, this);
            }
        }
        return null;
    }

    @Override
    public ErrorMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public ILogicListSorter getSorter() {
        return this.energy_sorter;
    }
}

