/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.fluids.handling;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.utils.Pair;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.readers.IListReader;
import sonar.logistics.base.channels.handling.ListNetworkChannels;
import sonar.logistics.core.tiles.displays.info.InfoPacketHelper;
import sonar.logistics.core.tiles.displays.info.types.fluids.FluidChangeableList;
import sonar.logistics.core.tiles.displays.info.types.fluids.InfoNetworkFluid;
import sonar.logistics.core.tiles.readers.fluids.handling.FluidNetworkHandler;

public class FluidNetworkChannels
extends ListNetworkChannels<InfoNetworkFluid, FluidNetworkHandler> {
    public List<FluidStack> forRapidUpdate = new ArrayList<FluidStack>();

    public FluidNetworkChannels(ILogisticsNetwork network) {
        super(FluidNetworkHandler.INSTANCE, network);
    }

    @Override
    public void updateChannel() {
        if (this.forRapidUpdate.isEmpty()) {
            super.updateChannel();
        } else {
            this.performRapidUpdates();
        }
    }

    public void performRapidUpdates() {
        this.updateAllChannels();
        for (IListReader reader : this.readers) {
            Pair updateList = ((FluidNetworkHandler)this.handler).updateAndSendList(this.network, reader, this.channels, false);
            InfoPacketHelper.sendRapidFluidUpdate(reader, (InfoUUID)updateList.a, (FluidChangeableList)updateList.b, this.forRapidUpdate);
        }
        this.forRapidUpdate.clear();
    }

    public void createRapidFluidUpdate(List<FluidStack> items) {
        block0: for (FluidStack stack : items) {
            for (FluidStack stored : this.forRapidUpdate) {
                if (!StoredFluidStack.isEqualStack((FluidStack)stored, (FluidStack)stack)) continue;
                continue block0;
            }
            this.forRapidUpdate.add(stack.copy());
        }
    }
}

