/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.integration.ae2;

import appeng.api.AEApi;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.core.Api;
import appeng.tile.storage.TileDrive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.logistics.api.asm.ASMTileInfoProvider;
import sonar.logistics.api.core.tiles.displays.info.IProvidableInfo;
import sonar.logistics.api.core.tiles.displays.info.handlers.ITileInfoProvider;
import sonar.logistics.api.core.tiles.displays.info.register.IMasterInfoRegistry;
import sonar.logistics.api.core.tiles.displays.info.register.LogicPath;
import sonar.logistics.integration.ae2.AE2DriveInfo;

@ASMTileInfoProvider(handlerID="ae2-drive", modid="appliedenergistics2")
public class AE2DriveProvider
implements ITileInfoProvider {
    @Override
    public boolean canProvide(World world, IBlockState state, BlockPos pos, EnumFacing dir, TileEntity tile, Block block) {
        return tile instanceof TileDrive;
    }

    @Override
    public void provide(IMasterInfoRegistry registry, List<IProvidableInfo> infoList, LogicPath currentPath, Integer methodCode, World world, IBlockState state, BlockPos pos, EnumFacing dir, Block block, TileEntity tile) {
        TileDrive drives = (TileDrive)tile;
        ArrayList<AE2DriveInfo> allInfo = new ArrayList<AE2DriveInfo>();
        long totalBytes = 0L;
        long usedBytes = 0L;
        long totalTypes = 0L;
        long usedTypes = 0L;
        long itemCount = 0L;
        for (int i = 0; i < drives.getInternalInventory().getSlots(); ++i) {
            ItemStack is = drives.getInternalInventory().getStackInSlot(i);
            List<IMEInventoryHandler> handlers = new ArrayList<IMEInventoryHandler>();
            if (!is.func_190926_b()) {
                ICellInventoryHandler itemInventory = AEApi.instance().registries().cell().getCellInventory(is, null, Api.INSTANCE.storage().getStorageChannel(IItemStorageChannel.class));
                ICellInventoryHandler fluidInventory = AEApi.instance().registries().cell().getCellInventory(is, null, Api.INSTANCE.storage().getStorageChannel(IFluidStorageChannel.class));
                handlers = Arrays.asList(itemInventory, fluidInventory);
            }
            AE2DriveInfo info = (AE2DriveInfo)new AE2DriveInfo(handlers, i + 1).setPath(currentPath.dupe());
            totalBytes += ((Long)info.totalBytes.getObject()).longValue();
            usedBytes += ((Long)info.usedBytes.getObject()).longValue();
            totalTypes += ((Long)info.totalTypes.getObject()).longValue();
            usedTypes += ((Long)info.usedTypes.getObject()).longValue();
            itemCount += ((Long)info.itemCount.getObject()).longValue();
            allInfo.add(info);
        }
        AE2DriveInfo driveInfo = (AE2DriveInfo)new AE2DriveInfo().setPath(currentPath.dupe());
        driveInfo.totalBytes.setObject((Object)totalBytes);
        driveInfo.usedBytes.setObject((Object)usedBytes);
        driveInfo.totalTypes.setObject((Object)totalTypes);
        driveInfo.usedTypes.setObject((Object)usedTypes);
        driveInfo.itemCount.setObject((Object)itemCount);
        infoList.add(driveInfo);
        infoList.addAll(allInfo);
    }
}

