/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api.book.gui;

import com.buuz135.industrial.api.book.CategoryEntry;
import com.buuz135.industrial.api.book.IPage;
import com.buuz135.industrial.api.book.button.CategoryEntryButton;
import com.buuz135.industrial.api.book.button.TextureButton;
import com.buuz135.industrial.api.book.gui.GUIBookCategoryEntries;
import com.buuz135.industrial.api.book.gui.GUIBookPage;
import com.buuz135.industrial.api.book.page.PageText;
import com.buuz135.industrial.book.BookCategory;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class GUIBookBase
extends GuiScreen {
    public static final ResourceLocation BOOK_EXTRAS = new ResourceLocation("industrialforegoing", "textures/gui/extras.png");
    public static final ResourceLocation BOOK_BACK = new ResourceLocation("industrialforegoing", "textures/gui/book_back.png");
    private GuiScreen prevScreen;
    private GUIBookBase prevBase;
    private int guiXSize;
    private int guiYSize;
    private int guiLeft;
    private int guiTop;
    private GuiButton back;
    private GuiButton left;
    private GuiButton right;
    private GuiTextField search;

    public GUIBookBase(GuiScreen prevScreen, GUIBookBase prevBase) {
        this.prevScreen = prevScreen;
        this.prevBase = prevBase;
        float scale = 0.65f;
        this.guiXSize = (int)(256.0f * scale);
        this.guiYSize = (int)(312.0f * scale);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.guiXSize) / 2;
        this.guiTop = (this.field_146295_m - this.guiYSize) / 2;
        if (this.hasBackButton()) {
            this.back = new TextureButton(-135, this.guiLeft - 5, this.guiTop + 2, 18, 10, BOOK_EXTRAS, 1, 27, "Go back");
            this.field_146292_n.add(this.back);
        }
        if (this.hasPageLeft()) {
            this.left = new TextureButton(-136, this.guiLeft + 20, this.guiTop + this.guiYSize - 25, 18, 10, BOOK_EXTRAS, 1, 14, "Previous page");
            this.field_146292_n.add(this.left);
        }
        if (this.hasPageRight()) {
            this.right = new TextureButton(-137, this.guiLeft + this.guiXSize - 45, this.guiTop + this.guiYSize - 25, 18, 10, BOOK_EXTRAS, 1, 1, "Next page");
            this.field_146292_n.add(this.right);
        }
        if (this.hasSearchBar()) {
            this.search = new GuiTextField(-138, this.field_146289_q, this.guiLeft + 20, this.guiTop + 15, 128, 12);
            this.search.func_146203_f(50);
            this.search.func_146185_a(true);
        }
    }

    public boolean hasPageLeft() {
        return false;
    }

    public boolean hasPageRight() {
        return false;
    }

    public boolean hasBackButton() {
        return false;
    }

    public boolean hasSearchBar() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawScreenBack(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawScreenFront(mouseX, mouseY, partialTicks);
    }

    public void drawScreenBack(int mouseX, int mouseY, float partialTicks) {
        this.func_73732_a(Minecraft.func_71410_x().field_71466_p, TextFormatting.DARK_AQUA + new TextComponentTranslation("text.industrialforegoing.book.title", new Object[0]).func_150254_d(), this.getGuiLeft() + 85, this.getGuiTop() - 10, 0xFFFFFF);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BOOK_BACK);
        GUIBookBase.func_146110_a((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)this.guiXSize, (int)this.guiYSize, (float)this.guiXSize, (float)this.guiYSize);
        if (this.hasSearchBar()) {
            if (!this.search.func_146206_l() || this.search.func_146179_b().isEmpty()) {
                // empty if block
            }
            this.search.func_146194_f();
        }
    }

    public void drawScreenFront(int mouseX, int mouseY, float partialTicks) {
        this.field_146292_n.stream().filter(GuiButton::func_146115_a).forEach(guiButton -> {
            if (guiButton instanceof CategoryEntryButton) {
                this.func_146279_a(guiButton.field_146126_j, guiButton.field_146128_h + 8, guiButton.field_146129_i + GUIBookCategoryEntries.SPACE - 1);
            } else {
                this.func_146279_a(guiButton.field_146126_j, mouseX, mouseY);
            }
        });
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (this.hasBackButton() && this.back == button) {
            this.onBackButton();
        }
        if (this.hasPageRight() && this.right == button) {
            this.onRightButton();
        }
        if (this.hasPageLeft() && this.left == button) {
            this.onLeftButton();
        }
        if (button instanceof CategoryEntryButton) {
            for (BookCategory category : BookCategory.values()) {
                for (ResourceLocation location : category.getEntries().keySet()) {
                    if (!((CategoryEntryButton)button).getEntry().equals(category.getEntries().get(location))) continue;
                    this.field_146297_k.func_147108_a((GuiScreen)new GUIBookPage(this, this, category.getEntries().get(location)));
                }
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.hasSearchBar()) {
            this.search.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.hasSearchBar()) {
            this.search.func_146178_a();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.hasSearchBar() && this.search.func_146206_l()) {
            this.search.func_146201_a(typedChar, keyCode);
            this.updateGUIwithBar(this.search.func_146179_b());
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void updateGUIwithBar(String text) {
        if (!text.isEmpty()) {
            this.field_146292_n.removeIf(guiButton -> guiButton instanceof CategoryEntryButton);
            int buttonsAdded = 0;
            for (BookCategory category : BookCategory.values()) {
                for (ResourceLocation location : category.getEntries().keySet()) {
                    if (!category.getEntries().get(location).getName().toLowerCase().contains(text.toLowerCase())) continue;
                    this.func_189646_b(new CategoryEntryButton(-315 - buttonsAdded, this.getGuiLeft() + 16, this.getGuiTop() + 32 + GUIBookCategoryEntries.SPACE * buttonsAdded, this.getGuiXSize() - 32, GUIBookCategoryEntries.SPACE, category.getEntries().get(location).getName(), category.getEntries().get(location)));
                    if (++buttonsAdded < 9) continue;
                    return;
                }
            }
            for (BookCategory category : BookCategory.values()) {
                for (ResourceLocation location : category.getEntries().keySet()) {
                    CategoryEntry entry = category.getEntries().get(location);
                    for (IPage page : entry.getPages()) {
                        if (!(page instanceof PageText) || !((PageText)page).getText().toLowerCase().contains(text.toLowerCase()) || !this.field_146292_n.stream().filter(guiButton -> guiButton instanceof CategoryEntryButton).noneMatch(guiButton -> ((CategoryEntryButton)((Object)guiButton)).getEntry().equals(entry))) continue;
                        this.func_189646_b(new CategoryEntryButton(-315 - buttonsAdded, this.getGuiLeft() + 16, this.getGuiTop() + 32 + GUIBookCategoryEntries.SPACE * buttonsAdded, this.getGuiXSize() - 32, GUIBookCategoryEntries.SPACE, entry.getName(), entry));
                        if (++buttonsAdded < 9) continue;
                        return;
                    }
                }
            }
        }
    }

    public void onRightButton() {
    }

    public void onBackButton() {
        this.field_146297_k.func_147108_a((GuiScreen)this.prevBase);
    }

    public void onLeftButton() {
    }

    public int getGuiXSize() {
        return this.guiXSize;
    }

    public int getGuiYSize() {
        return this.guiYSize;
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }
}

