/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SonarSlab
extends BlockSlab {
    public static final PropertyBool SEAMLESS = PropertyBool.func_177716_a((String)"seamless");
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public SonarSlab(Material material) {
        super(material);
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.FALSE) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        this.func_180632_j(iblockstate.func_177226_a(VARIANT, (Comparable)((Object)EnumType.STONE)));
        this.func_149647_a(CreativeTabs.field_78030_b);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150333_U);
    }

    @Nonnull
    public ItemStack func_185473_a(World worldIn, BlockPos pos, @Nonnull IBlockState state) {
        return new ItemStack((Block)Blocks.field_150333_U, 1, ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata());
    }

    @Nonnull
    public String func_150002_b(int meta) {
        return super.func_149739_a() + '.' + EnumType.byMetadata(meta).getUnlocalizedName();
    }

    @Nonnull
    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    @Nonnull
    public Comparable<?> func_185674_a(@Nonnull ItemStack stack) {
        return EnumType.byMetadata(stack.func_77960_j() & 7);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this != Blocks.field_150334_T) {
            for (EnumType blockstoneslab$enumtype : EnumType.values()) {
                if (blockstoneslab$enumtype == EnumType.WOOD) continue;
                list.add((Object)new ItemStack((Block)this, 1, blockstoneslab$enumtype.getMetadata()));
            }
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta & 7)));
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.valueOf((meta & 8) != 0)) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
        if (this.func_176552_j()) {
            if (((Boolean)state.func_177229_b((IProperty)SEAMLESS)).booleanValue()) {
                i |= 8;
            }
        } else if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{SEAMLESS, VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public MapColor getMapColor(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMapColor();
    }

    public static enum EnumType implements IStringSerializable
    {
        STONE(0, MapColor.field_151665_m, "stone"),
        SAND(1, MapColor.field_151658_d, "sandstone", "sand"),
        WOOD(2, MapColor.field_151663_o, "wood_old", "wood"),
        COBBLESTONE(3, MapColor.field_151665_m, "cobblestone", "cobble"),
        BRICK(4, MapColor.field_151645_D, "brick"),
        SMOOTHBRICK(5, MapColor.field_151665_m, "stone_brick", "smoothStoneBrick"),
        NETHERBRICK(6, MapColor.field_151655_K, "nether_brick", "netherBrick"),
        QUARTZ(7, MapColor.field_151677_p, "quartz");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final MapColor mapColor;
        private final String name;
        private final String unlocalizedName;

        private EnumType(int p_i46381_3_, MapColor p_i46381_4_, String p_i46381_5_) {
            this(p_i46381_3_, p_i46381_4_, p_i46381_5_, p_i46381_5_);
        }

        private EnumType(int p_i46382_3_, MapColor p_i46382_4_, String p_i46382_5_, String p_i46382_6_) {
            this.meta = p_i46382_3_;
            this.mapColor = p_i46382_4_;
            this.name = p_i46382_5_;
            this.unlocalizedName = p_i46382_6_;
        }

        public int getMetadata() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockstoneslab$enumtype;
                EnumType.META_LOOKUP[blockstoneslab$enumtype.getMetadata()] = blockstoneslab$enumtype = enumTypeArray[i];
            }
        }
    }
}

