/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.planting;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.core.SonarCore;
import sonar.core.api.planting.ISonarFertiliser;
import sonar.core.api.planting.ISonarHarvester;
import sonar.core.api.planting.ISonarPlanter;

public class PlantingHandler {
    public List<ISonarHarvester> harvesters = new ArrayList<ISonarHarvester>();
    public List<ISonarPlanter> planters = new ArrayList<ISonarPlanter>();
    public List<ISonarFertiliser> fertilisers = new ArrayList<ISonarFertiliser>();

    public static PlantingHandler instance() {
        return SonarCore.instance.planting_handler;
    }

    @Nullable
    public ISonarPlanter getPlanter(ItemStack seeds) {
        for (ISonarPlanter planter : this.planters) {
            if (!planter.isPlantable(seeds)) continue;
            return planter;
        }
        return null;
    }

    @Nullable
    public ISonarPlanter getPlanter(ItemStack seeds, int tier) {
        for (ISonarPlanter planter : this.planters) {
            if (!planter.isPlantable(seeds) || !planter.canTierPlant(seeds, tier)) continue;
            return planter;
        }
        return null;
    }

    @Nullable
    public ISonarHarvester getHarvester(World world, BlockPos pos, IBlockState state) {
        for (ISonarHarvester harvester : this.harvesters) {
            if (!harvester.canHarvest(world, pos, state)) continue;
            return harvester;
        }
        return null;
    }

    @Nullable
    public ISonarFertiliser getFertiliser(World world, BlockPos pos, IBlockState state) {
        for (ISonarFertiliser fertiliser : this.fertilisers) {
            if (!fertiliser.canFertilise(world, pos, state)) continue;
            return fertiliser;
        }
        return null;
    }

    public boolean doFertilise(World world, BlockPos pos, IBlockState state) {
        ISonarFertiliser fertiliser = this.getFertiliser(world, pos, state);
        if (fertiliser != null && fertiliser.canGrow(world, pos, state)) {
            return fertiliser.grow(world, pos, state);
        }
        return false;
    }
}

