/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.ogex;

import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexColor;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTexture;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseMaterialized {
    private Map<String, OgexColor> colors = new HashMap<String, OgexColor>();
    private Map<String, Float> params = new HashMap<String, Float>();
    private Map<String, OgexTexture> textures = new HashMap<String, OgexTexture>();

    protected BaseMaterialized() {
    }

    public void setColor(String name, OgexColor color) {
        if (color == null) {
            this.colors.remove(name);
        } else {
            this.colors.put(name, color);
        }
    }

    public OgexColor getColor(String name, OgexColor defaultValue) {
        OgexColor result = this.getColor(name);
        return result == null ? defaultValue : result;
    }

    public OgexColor getColor(String name) {
        return this.colors.get(name);
    }

    public void setTexture(String name, OgexTexture texture) {
        if (texture == null) {
            this.textures.remove(name);
        } else {
            this.textures.put(name, texture);
        }
    }

    public OgexTexture getTexture(String name, OgexTexture defaultValue) {
        OgexTexture result = this.getTexture(name);
        return result == null ? defaultValue : result;
    }

    public OgexTexture getTexture(String name) {
        return this.textures.get(name);
    }

    public void setParam(String name, Float value) {
        if (value == null) {
            this.params.remove(name);
        } else {
            this.params.put(name, value);
        }
    }

    public float getParam(String name, float defaultValue) {
        Float result = this.getParam(name);
        return result == null ? defaultValue : result.floatValue();
    }

    public Float getParam(String name) {
        return this.params.get(name);
    }

    protected void appendFieldStrings(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append("params=" + this.params);
        sb.append(", colors=" + this.colors);
        sb.append(", textures=" + this.textures);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendFieldStrings(sb);
        return this.getClass().getSimpleName() + "[" + sb + "]";
    }
}

